const db = require('../models/db');
const resourceLibrary = require('../utils/resourceLibrary');

async function migrate() {
  try {
    const [tests] = await db.query('SELECT DISTINCT Test FROM TestQuesCSV5');
    for (const row of tests) {
      const name = row.Test;
      await db.query(
        `INSERT INTO LMSTest5 (Question, Answer, Explanation, Picture, OptionA, OptionB, OptionC, OptionD, OptionE, OptionF, OptionG, Test, \`Content Type\`, Title, \`Item Type\`, Path)
         SELECT Question, Answer, Explanation, Picture, OptionA, OptionB, OptionC, OptionD, OptionE, OptionF, OptionG, ?, \`Content Type\`, ?, \`Item Type\`, Path FROM TestQuesCSV5 WHERE Test = ?`,
        [name, name, name]
      );
      try { resourceLibrary.addTest({ title: name, timeLimit: 90 }); } catch (_) {}
    }
    console.log(`Migrated ${tests.length} tests from TestQuesCSV5.`);
  } catch (e) {
    console.error('Migration failed:', e);
  } finally {
    await db.end();
  }
}

migrate();
