(function(){
  const root = document.documentElement;
  fetch('/branding.json')
    .then(r => r.json())
    .then(b => {
      if (b.primaryColor) root.style.setProperty('--primary-color', b.primaryColor);
      if (b.secondaryColor) root.style.setProperty('--secondary-color', b.secondaryColor);
    })
    .catch(() => {});
  const stored = localStorage.getItem('theme');
  if (stored === 'dark' || stored === 'light') {
    root.setAttribute('data-theme', stored);
  }
  window.setupThemeToggle = function(id){
    const btn = document.getElementById(id);
    if (!btn) return;
    function update(){
      const isDark = root.getAttribute('data-theme') === 'dark';
      btn.textContent = isDark ? 'Light Mode' : 'Dark Mode';
    }
    btn.addEventListener('click', function(){
      const isDark = root.getAttribute('data-theme') === 'dark';
      const next = isDark ? 'light' : 'dark';
      root.setAttribute('data-theme', next);
      localStorage.setItem('theme', next);
      update();
    });
    update();
  };

  function ensureGlobalHomeButton() {
    if (document.querySelector('[data-global-home-button]')) return;
    const styleId = 'global-home-button-style';
    if (!document.getElementById(styleId)) {
      const style = document.createElement('style');
      style.id = styleId;
      style.textContent = `
        .global-home-button {
          position: fixed;
          bottom: 1.5rem;
          right: 1.5rem;
          z-index: 1090;
          display: inline-flex;
          align-items: center;
          gap: .5rem;
          padding: .65rem 1.1rem;
          border-radius: 999px;
          background: var(--primary-color, #0d6efd);
          color: #fff;
          font-weight: 600;
          text-decoration: none;
          box-shadow: 0 .75rem 1.5rem rgba(13, 110, 253, .25);
          transition: transform .15s ease, box-shadow .15s ease, background .15s ease;
        }
        .global-home-button:hover {
          text-decoration: none;
          transform: translateY(-2px);
          box-shadow: 0 1rem 2rem rgba(13, 110, 253, .35);
          background: var(--secondary-color, #6610f2);
          color: #fff;
        }
        .global-home-button svg {
          width: 1.1rem;
          height: 1.1rem;
        }
        @media print {
          .global-home-button {
            display: none !important;
          }
        }
        @media (max-width: 575px) {
          .global-home-button {
            bottom: 1rem;
            right: 1rem;
            padding: .55rem .95rem;
          }
        }
      `;
      document.head.appendChild(style);
    }

    const link = document.createElement('a');
    link.href = '/dashboard';
    link.className = 'global-home-button';
    link.setAttribute('data-global-home-button', 'true');
    link.setAttribute('aria-label', 'Back to dashboard');
    link.innerHTML = `
      <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor" aria-hidden="true">
        <path d="M8 .5a1 1 0 0 0-.64.23l-7 6a1 1 0 0 0 1.28 1.54l.86-.77V14a2 2 0 0 0 2 2h2.5a.5.5 0 0 0 .5-.5V11a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v4.5a.5.5 0 0 0 .5.5H11a2 2 0 0 0 2-2V7.5l.86.77a1 1 0 0 0 1.28-1.54l-7-6A1 1 0 0 0 8 .5Z"/>
      </svg>
      Home
    `;
    document.body.appendChild(link);
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', ensureGlobalHomeButton);
  } else {
    ensureGlobalHomeButton();
  }
})();
