# MDTS Teacher Playbook

Welcome to the MD Technical School Learning Management System (LMS). This guide walks you through every tool available to instructors so you can run classes smoothly, track student progress, and stay on top of communication.

---

## Table of Contents

1. [Access & Profile](#1-access--profile)
2. [Teacher Dashboard](#2-teacher-dashboard)
3. [Class Workspaces](#3-class-workspaces)
    - [Overview tab](#overview-tab)
    - [Schedule tab](#schedule-tab)
    - [Class Checklist](#class-checklist)
4. [Learning Resources](#4-learning-resources)
    - [Lectures](#lectures)
    - [Simulations](#simulations)
    - [Assignments](#assignments)
    - [Resource Libraries](#resource-libraries)
5. [Assessments & Tests](#5-assessments--tests)
6. [Attendance Tracking](#6-attendance-tracking)
7. [Gradebook & Analytics](#7-gradebook--analytics)
8. [Communicating with Students](#8-communicating-with-students)
9. [Calendar & Events](#9-calendar--events)
10. [Reports & Downloads](#10-reports--downloads)
11. [Teacher Utilities](#11-teacher-utilities)
12. [Account Settings](#12-account-settings)
13. [Best Practices & Tips](#13-best-practices--tips)
14. [Troubleshooting & FAQ](#14-troubleshooting--faq)
15. [Change Log](#15-change-log)

---

## 1. Access & Profile

### Sign in
1. Navigate to the LMS login page.
2. Enter the username and temporary password provided in your welcome email.  
3. You will be prompted to create a new secure password on your first login.

### Update your profile
- Go to **Account** in the top navigation and review your information.
- Upload an optional profile photo and digital signature.
- Add external resource links (e.g., class websites or office hours booking).
- Keep your contact email current—students see the address when you message them.

![Image](/docs/images/TeacherAccount.png)

---

## 2. Teacher Dashboard

The dashboard is your command center. You can open it anytime from **Home**.

### Quick actions
- **Topic Helper** – generates teaching ideas, outlines, or analogies for tough topics.
- **Reports** – opens instructor-friendly summaries and downloadable grade reports.
- Look for the `?` icons beside each quick-action button; these explain what the shortcut does.
- **Account** – opens your personal settings so you can update profile and security details (photo, signature name, Teacher Links, password).

### My Classes panel
Shows every class assigned to you. For each class:
- View the scheduled meeting pattern.
- Jump directly to Lectures, Simulations, or Tests with one click.
- Use the `?` icon for a refresher on what each button does.

![Image](/docs/images/teacherdash.png)

### Weekly schedule (calendar)
- Visual timeline of upcoming classes.
- Click a class event to open the class workspace.
- Use the calendar dropdown to switch between week and month views on smaller screens.

---

## 3. Class Workspaces

Open a class from **My Classes** or the **Teacher → Classes** page. Each class card contains several sections with `?` icons that describe their purpose.

### Overview tab
- Summarize the course and list important dates.
- Students see this description on their dashboard, so keep it concise and up to date.

### Schedule tab
- Add recurring meeting days/times.
- Mark holidays or skipped sessions—the badge displays automatically.

![Image](/docs/images/classover.png)

### Class Checklist
- Track pre-class prep, field trips, equipment needs, etc.
- Use **Add Item** for new tasks and save once complete.
- Checkboxes help you and co-teachers stay organized.

> [Add screenshot: Class Checklist with items]

---

## 4. Learning Resources

### Lectures
- Attach slide decks, videos, or handouts.
- Add links manually or pull from the shared **Lecture Library**.
- Use the inline edit form to adjust titles or dates without leaving the page.

![Image](/docs/images/lectures.png)

### Simulations
- Provide interactive practice tools.
- Tag submissions with dates and titles so students understand the context.
- Library integration mirrors the lecture workflow.
- Many simulations are preconfigured in the **Simulation Library** so you can quickly attach and reuse them across classes.

![Image](/docs/images/sims.png)
![Image](/docs/images/simex.png)

### Assignments
- Post assignment links with optional due dates.
- Track submission counts directly from the list (a green badge appears as work is turned in).
- Edit or remove assignments in-line after posting.

![Image](/docs/images/assignments.png)

### Resource Libraries
- Every resource form includes a dropdown of reusable items.
- Selecting a library entry auto-fills the necessary fields; you can still customize details before saving.

---

## 5. Assessments & Tests

- Click **Tests** within a class to manage quizzes and exams.
- Tabs organize the tools:
  - **Test / Quiz** – assign existing tests and set due dates.
  - **Upload Test** – import questions via CSV template.
  - **Upload Media** – attach audio, video, or images used inside tests.
  - **Create AI Test** – generate draft questions with AI (review before publishing).
- Preview any test before releasing it to students.
- Edit titles or due dates inline; save changes immediately.

### Using an existing test (library)
- Open the **Test / Quiz** tab and use the library dropdown to select a prebuilt test.
- Set an optional due date and add it to your class.

![Image](/docs/images/test.png)

### Create a test from the CSV template
1. Click **Upload Test**.
2. Download the CSV template (link is provided on the page).
3. Fill in the columns for Question, Answer, Explanation, Options A–G, and optional metadata.
4. Save the CSV and upload it back on the same tab.
5. Set a time-per-question if needed and submit.

Tips:
- Keep questions concise; explanations improve learning after the test.
- You can combine media (see next tab) for richer prompts.

![Image](/docs/images/testquiz.png)

### Create an AI-generated test (in depth)
1. Click **Create AI Test**.
2. Enter a clear Title (e.g., “Unit 2: Respiratory System Review”).
3. In the Prompt, describe the topic, level, and any constraints (e.g., “15 multiple-choice questions, beginner to intermediate, include rationales”).
4. Set the Question Count (e.g., 10–50) and the Time per Question (e.g., 90 seconds).
5. Click **Generate via AI**. The draft test is created; review items for accuracy and alignment.
6. Edit any question/answers as needed, then save/assign to the class.

Notes:
- AI content is a starting point—always validate correctness and tone.
- Keep reading level, scope, and prohibited topics explicit in your prompt.

![Image](/docs/images/testquizai.png)

---

## 6. Attendance Tracking

- Navigate to the **Attendance** section within a class:
  1. Pick the date you are recording.
  2. Use the toggle switches to mark students present.
  3. Click **Save Attendance** to log the session.
- The lower table stores historical attendance so you can audit participation over time.
- Use the **Print Overall Attendance** button for paper copies or compliance records.
- The mobile-friendly list allows quick roll calls from a phone or tablet.

![Image](/docs/images/attendance.png)

---

## 7. Gradebook & Analytics

- Everything you grade appears in the **Gradebook** section.
- Features include:
  - Inline editing of scores for tests, assignments, and simulations.
  - Automatic class averages shown at the bottom of each column.
  - Quick actions for printing, exporting CSVs, and reviewing statistics.
  - Direct link to the attendance report to cross-check engagement.
- Tip: Save regularly after bulk updates to ensure all scores persist.

### Working the gradebook (deep dive)
- Columns: Tests, Assignments, and Simulations appear with one column per activity; totals/averages show in the footer.
- Inline editing: click any score cell, enter a number, and click away to commit. Use **Save Grades** to persist.
- Sorting/filtering: use the controls above the table (if present) to sort by name, filter by status, or search.
- CSV export: pulls the currently visible data—use filters first if you want a subset.
- Printing: uses a print-optimized layout to fit on fewer pages.

![Image](/docs/images/gradebook.png)

### Certificates of completion
- From the **Gradebook** or class roster, click the certificate button to send a PDF to the selected student.
- A copy can be CC’ed to admins automatically; the certificate is also saved in the student profile.
- If a send fails, try again later or contact an admin.

![Image](/docs/images/certsend.png)

---

## 8. Communicating with Students

### Discussion board
- Post announcements that stay visible to the whole class.
- Replies show who responded and at what time.

### Direct contact
- Use the **Contact** button next to any student (available in Attendance).
- Compose personalized messages with formatting tools and optional links.
- Messages route through the school’s email system for consistency.

### Announcements page
- Accessible from the top navigation (**Announcements**).
- Review all posts you have published or received from administrators.

---

## 9. Calendar & Events

- View class schedules on your dashboard calendar.
- For school-wide events (interviews, workshops, etc.) check the **Events Dashboard** (admins may invite you when relevant).
- When admins tag you on a calendar item, it will show up automatically.

---

## 10. Reports & Downloads

- From the header, choose **Reports** to open teacher-specific analytics.
- Within a class you can:
  - **Print Gradebook** – formatted for meetings or parent conferences.
  - **Export Grades CSV** – import into spreadsheets or SIS tools.
  - **Attendance Report** – dedicated route for attendance-only exports.
- Admins may request data snapshots; these buttons make it easy to provide them.

---

## 11. Teacher Utilities

- **Topic Helper**: brainstorming aid for lesson plans or remediation.
- **Resource Links**: add optional URLs to your profile so students can find office hours, booking calendars, or repositories.
- **Signature Upload**: attach a digital signature for official documents (transcripts, certificates).

### Teacher Links
- From your **Account** page, add useful URLs (e.g., Zoom room, class portal, calendars, resource repositories).
- These links can be shown to students from your profile or class pages when relevant.
- Optional: upload an icon/image to make the link more recognizable.

![Image](/docs/images/teacherlinks.png)

---

## 12. Account Settings

From the **Account** page you can manage every part of your instructor profile—just like the admin can when setting it up for the first time.

### Update profile details
1. Click **Account** in the top navigation.
2. Use the Profile card to adjust your display name and signature name, upload or replace your profile picture, and add a digital signature image for documents.
3. Add or edit Teacher Links so students can reach your office hours, class site, or other resources.
4. Review your contact information and click **Save** to publish the updates immediately.

> [Add screenshot: Account page – profile & links]

### Change your password
1. In the **Account** view, open the Password section.
2. Enter your current password, then a new secure password.
3. Confirm the new password and click **Save**.

Notes:
- If you are prompted to change your password at login, you must complete it before accessing other pages.
- If you forget your password, use **Forgot Password** on the login screen to receive a reset link via email.

![Image](/docs/images/Passwordchang.png)

---

## 13. Best Practices & Tips

- **Set expectations early**: Populate the Overview and Schedule before the term starts.
- **Reuse resources**: Libraries save time—add high-quality lectures or assignments once and pull them into future classes.
- **Track attendance daily**: Doing so keeps the cumulative log accurate and simplifies reporting.
- **Provide timely feedback**: Update gradebook items soon after grading to keep progress transparent.
- **Use discussions for reminders**: Students see posts immediately when they log in.
- **Document interventions**: Use the checklist or notes to record outreach attempts for struggling students.
- **Back up exports**: Save CSV exports when closing a term for your personal records.

---

## 14. Troubleshooting & FAQ

**I forgot my password.**  
Use the **Forgot Password** link on the login screen. You will receive an email to reset it. Contact an administrator if the email does not arrive within 5 minutes.

**A student cannot see an assignment.**  
Confirm the assignment URL is correct and published. If you used the library, verify that the resource still exists. You can re-add or edit the entry without losing submission history.

**My grade changes did not save.**  
Check for unsaved edits—after typing a score, click elsewhere to commit the value, then press **Save Grades**. If you navigate away without saving, the LMS reverts to the previous values.

**A test did not appear for students.**  
Make sure the test has a title, time limit (if required), and was added to the correct class. Previewing the test first helps ensure all questions imported correctly.

**I need to send login details again.**  
Admins can resend credentials from the Teacher List. Contact the admin team if a colleague is locked out.

**Something isn’t working as expected.**  
Please contact one of the MD Tech admins. Include your class name, what you tried, and any error messages you saw.

**The calendar shows the wrong time.**  
Double-check the start and end times in the Schedule section and update them. Changes synchronize instantly with the dashboard calendar.

---

## 15. Change Log

- **January 2025** – Added inline help icons and updated quick actions.
- **December 2024** – Introduced AI test generator and enhanced gradebook exports.
- **October 2024** – Launched resource libraries for lectures, simulations, and assignments.

---

Need more help? Reach out to the MDTS admin team or submit a ticket through the **Account → Support** option. We're here to help you teach with confidence.
