# MDTS Admin Operations Manual

This playbook explains every administrative workflow in the MD Technical School LMS. Use the table of contents to jump to any section.

---

## Table of Contents

1. [Access & Security](#1-access--security)
2. [Admin Dashboard Overview](#2-admin-dashboard-overview)
3. [Managing Users](#3-managing-users)
4. [Pre-Registrations & Enrollment Pipeline](#4-pre-registrations--enrollment-pipeline)
5. [Class Management](#5-class-management)
6. [Teacher Onboarding & Support](#6-teacher-onboarding--support)
7. [Student Documents & Certificates](#7-student-documents--certificates)
8. [Marketing, Events & Outreach](#8-marketing-events--outreach)
9. [Calendar & Scheduling](#9-calendar--scheduling)
10. [Reports & Analytics](#10-reports--analytics)
11. [Testing Library & Assessments](#11-testing-library--assessments)
12. [Messaging & Announcements](#12-messaging--announcements)
13. [Settings & Configuration](#13-settings--configuration)
14. [Data Exports & Compliance](#14-data-exports--compliance)
15. [Troubleshooting & Support](#15-troubleshooting--support)
16. [Change Log](#16-change-log)

---

## 1. Access & Security

- Admin accounts are provisioned by MD Tech leadership only.
- Always use strong, unique passwords.
- Sessions expire automatically after inactivity to protect student data.
- MFA is recommended wherever possible (coordinate with IT).

![Account page – Login](/docs/images/Login.png)


### Password resets

1. Navigate to **Account** in the header.
2. Use the **Change Password** section to update your password.
3. If you forget your password, use **Forgot Password** on the login page. The reset link is valid for a limited time.

![Account page – Login](/docs/images/PasswordChange.png)

---

## 2. Admin Dashboard Overview

The dashboard summarizes school-wide activity:

- **Hero Stats** – total classes, active students, and recent pre-registrations. Click any stat to jump to the underlying report.
- **Quick Actions** – curated shortcuts grouped by Students, Classes, Outreach/Marketing, Reports, and Other utilities. Every button triggers a frequently used workflow, and each `?` icon explains when to use it.
  - Students group covers the full enrollment lifecycle (Pre-Registered, Pending, Accepted, Denied).
  - Classes group opens the class list, creation form, teacher provisioning, and roster management.
  - Outreach/Marketing group launches event management, lead tracking, drip campaigns, partner/mentor management, and email templates.
  - Reports and Other groups expose analytics tools, audit data, dropdown maintenance, branding, admin accounts, and testing libraries.
- **Calendar** – administrative events with filters (Events, Interviews, Classes, Tests, Assignments, Custom). Use the checkboxes to toggle each layer, then add custom events or download the ICS.
- **My Charts** – displays the first eight charts you pin from the Report Charts builder. Use the move/remove buttons to reorder or delete existing cards.

![Account page – Login](/docs/images/admindash.png)

### Using Quick Actions

1. Hover over each button’s `?` icon to review its description.
2. Click the button to open the corresponding page in a new tab (pages retain your previous filters where possible).
3. After completing the task, use the browser back button or header navigation to return to the dashboard.
4. Encourage new admins to start every shift by reviewing the dashboard for alerts (pending signatures, upcoming events, etc.).

---

## 3. Managing Users

### Students

- **Pre-Registered Users** – review submitted forms; convert to full student accounts when requirements are met.
- **Pending Students** – approve/deny applications, view required documents, send onboarding emails, schedule interviews.
- **Accepted Students** – update profiles, add counselors, view progress, upload certificates, adjust tuition fields.
- **Denied Students** – maintain records for compliance; optionally re-open if the student reapplies.

![Account page – Login](/docs/images/pendingstudent.png)

Actions:
- From any student list, click a record to open the detailed profile. Tabs cover contact info, documents, applications, attendance, and notes.
- Use the **Status** controls to approve or deny the applicant. The LMS records who performed each action and when.
- Upload documents from the **Documents** section. Choose the appropriate category (Required Docs, Certifications, To-Sign). Add descriptions so teachers understand each file’s purpose.
- Assign mentors or counselors by selecting from the dropdowns; the system auto-notifies the assignee if configured.
- Reset passwords via the **Account** page or send login credentials from the student profile’s quick actions.
- Record manual interactions or calls in the **Notes/Interactions** section for auditing.

### Teachers

- **Teacher List** – view all instructors, activate/deactivate accounts, resend login credentials, filter by status.
  - Use the **Resend** button to email login details (username, new password) and automatically regenerate credentials.
  - Deactivate teacher accounts when instructors are no longer active; the LMS preserves historical data but blocks login.
- **Create Teacher** – provision a new teacher. Required fields: Name, Username, Email. Optional: profile photo upload, signature upload, resource links. Toggle “Send Welcome Email” to send credentials immediately.
- **Teacher Profile (admin view)** – upload profile photo, signature, add links, view classes, reset signatures. Encourage teachers to set their own signatures for document workflows.


![Account page – Login](/docs/images/teacherlist.png)

### Admins

- Create additional admins via **Other → Add Admin**. Confirm that new admins understand security policies.
- Reset admin passwords from **Other → Admins**; the system emails a new temporary password.
- Deactivate legacy accounts to maintain principle of least privilege.

---

## 4. Pre-Registrations & Enrollment Pipeline

- **Pre-Registrations** – review leads captured from the web form:
  1. Filter by campaign, status, or date.
  2. Open a record to verify contact information, course interest, and notes.
  3. Log calls/emails, schedule interviews, and create tasks.
  4. Use **Convert to Student** when the applicant is ready for enrollment—it pre-fills the student creation form.
- **Pending Students** – manage applications after conversion:
  - Track checklists for documents, interviews, and approvals.
  - Send onboarding emails, schedule additional interviews, or set follow-up reminders.
  - Update progress statuses (e.g., “Docs Received,” “Awaiting Payment”).
- **Accepted / Denied** – final resting place once a decision is made. Use the **Reopen** option if a student returns or appeals.

![Account page – Login](/docs/images/prereg.png)

Key tasks:
- Schedule interviews via the modal; selecting a time automatically notifies the assigned staff member and the applicant (email/SMS if configured).
- Track checklist items (transcripts, IDs, payments). Use the “Mark Collected” buttons to timestamp completion.
- Promote a pre-registrant to a full student with the conversion wizard. Confirm fields and click “Create Student” to generate login credentials.
- Keep notes updated—these appear in the audit report and help admins hand off cases smoothly.

---

## 5. Class Management

- **All Classes** – search and filter by name, teacher, cohort, or status; the list displays enrollment counts and start dates.
  - Click a class name to open the detail view.
  - Use the quick actions to edit, duplicate, or archive a class.
- **Create Class** – define:
  1. Basic info (name, short name, cohort, school year).
  2. Teacher assignment (pulls from active teachers).
  3. Start/end dates and schedule (enter day/time blocks).
  4. Optional description shown to students/teachers.
- **Duplicate Class** – clone structure, schedule, and resources from an existing class to a new term; adjust dates and teacher as needed.
- **Class Detail (admin view)** – multi-tab management:
  - **Overview**: description, key dates, weeks count, class checklist (shared with teachers).
  - **Roster**: add/remove students, view attendance summary, send emails.
  - **Lectures/Simulations/Assignments**: add resources, attach library items, track submissions. Admins can assist teachers by uploading shared content here.
  - **Tests**: assign tests, upload CSV, manage AI-generated assessments.
  - **Gradebook**: review grades, export CSV, print.
  - **Attendance**: mark attendance when covering for a teacher or auditing.

![Account page – Login](/docs/images/classover.png)

Tips:
- Ensure the schedule is correct before the first day—teacher dashboards pull from it.
- Use **Add Student** to enroll accepted students; they appear in teacher and student dashboards immediately.
- Rename classes when necessary using the quick action within the class detail page.
- Encourage teachers to update class checklists so admin staff can monitor progress.
- Archive classes at the end of a term only after exporting final grades and attendance.

---

## 6. Teacher Onboarding & Support

Responsibilities:
- Create teacher accounts and upload optional signatures.
- Encourage teachers to set their **Profile Picture**, **Digital Signature**, and **Teacher Links**.
- Use the **Resend** button on the teacher list to send login credentials again if a teacher is locked out (password resets are included).
- Monitor teacher dashboards for upcoming classes and verify resource links are set up.

![Account page – Login](/docs/images/createteacher.png)

---

## 7. Student Documents & Certificates

- **Document Uploads** – in the student profile, select the Documents tab:
  - Upload required documents (IDs, transcripts, forms) as PDF/JPG/PNG. Label appropriately.
  - For To-Sign documents, specify the signer role; the workflow tracks pending signatures.
- **Staff Signatures** – the dashboard alert shows documents awaiting staff signatures.
  1. Click the alert to open the queue.
  2. Review each document, add a signature, and mark as completed.
  3. The system updates status indicators for compliance tracking.
- **Certificates** – check the Certificates section in the student profile to verify when a teacher sent completion certificates.
  - Admins can resend certificates if a student requests another copy.
  - Use the stored URL to view the PDF that students access.

>![Account page – Login](/docs/images/agreesign.png)

Workflow:
1. Upload documents using the appropriate section (Required Docs, Certifications, To-Sign).
2. For signatures, assign the relevant admin/teacher; the system tracks pending signatures.
3. Certificates sent by teachers appear under the student’s certificate history.
4. Use **Download All** (if enabled) to bundle documents for audits.

---

## 8. Marketing, Events & Outreach

- **Marketing** – manage campaigns, templates, and sequences for outreach. Update subject lines, email bodies, and segments. Monitor open/click rates if available.
- **Events Dashboard** – create and track open houses, info sessions, workshops. Specify date/time, location, and target audience. Assign staff for coverage.
- **Interviews** – schedule and document applicant interviews; assign staff, track outcomes, and send reminders. Use status filters (Scheduled, Completed, No-Show).
- **Interactions / Leads** – log contact attempts (call, email, SMS). Update interest levels (hot/warm/cold). Send emails directly via the built-in composer. Export lead lists as needed.
- **Mentors & Partners** – maintain organizational contacts tied to students or programs. Upload partnership documents and notes. Link mentors to students or classes.
- **Drip Campaigns** – add leads to automated communication sequences based on segment (prospects, alumni, partners).

![Account page – Login](/docs/images/eventcal.png)

---

## 9. Calendar & Scheduling

- The admin calendar aggregates events, interviews, classes, tests, assignments, and custom entries. Each cell shows the count; click to open the day modal.
- Filters allow you to show or hide categories. Use the checkboxes to focus on a specific pipeline.
- Navigation buttons (Prev, Today, Next) adjust the month/week displayed.
- **Add Custom Event** workflow:
  1. Click **Add Custom Event**.
  2. Fill in title, description, start/end date, time (or mark all-day).
  3. Choose which admins/teachers to notify (multi-select sends targeted emails).
  4. Save to place it on the calendar; invited users receive notifications.
- Export options: download `.ics`, add to Google Calendar, add to Outlook (buttons in the calendar header).
- Day modal displays all events on a specific date. Use it to quickly drill into busy periods.

![Account page – Login](/docs/images/bigcal.png)

Best practices:
- Use consistent titles for easy searching.
- Notify relevant staff so they see events in their dashboards.
- Review the calendar daily for conflicts or gaps.
- Keep recurring administrative tasks (weekly staff meetings) on the calendar for visibility.

---

## 10. Reports & Analytics

- **Reports** – predefined analytics (enrollment summaries, attendance trends, financial snapshots). Many reports allow filtering by cohort, teacher, date range.
- **Report Charts** – build custom visualizations:
  1. Choose the table (students, classes, leads).
  2. Select metrics (count, sum, average).
  3. Apply filters/grouping.
  4. Preview the chart and save it to appear in **My Charts**.
- **Audit Report** – review critical changes (status updates, account creations, document uploads). Use filters for date range and actor. Export logs for compliance.
- **Custom CSV Exports** – many report tables include an **Export CSV** button to download the filtered dataset.

![Account page – Login](/docs/images/reports.png)

Remember:
- Saved charts appear in the dashboard **My Charts** section.
- Use chart filters (date ranges, fields) to tailor insights.
- Export data if you need to share with stakeholders.

---

## 11. Testing Library & Assessments

- **Test Library** – manage standardized tests for reuse. Organize by subject, difficulty, and time limit.
- **Admin Test Library** – upload new tests, associate metadata, and share with teachers.
  - Use the CSV template to bulk import questions.
  - Attach media assets (images/audio/video) that questions reference.
- Monitor teacher-created AI tests or uploaded tests for quality. Review and archive outdated assessments to keep the library clean.
- Coordinate with curriculum leads to align test templates with program requirements.


![Account page – Login](/docs/images/testlib.png)

When teachers request help:
- They can leverage template or AI-generated tests. Encourage them to review content carefully.
- Admins can assist by providing standardized templates or curated question banks.
- Use versioning or naming conventions (e.g., “2025_Q1 CNA Practice Exam”) to track updates.

---

## 12. Messaging & Announcements

- **Announcements** – publish school-wide notices to teachers or students. Choose the audience (teachers, students, both). Schedule posts if you want them to appear on a specific day.
- **Email Templates** – manage canned messages:
  - Edit subject, HTML body, and text fallback.
  - Use placeholder variables (e.g., `{{name}}`, `{{username}}`).
  - Save templates that other workflows (student approvals, teacher welcome emails) reference.
- **Mailbox** – review inbound/outbound communication if enabled. Filter by folder (inbox, sent, archived) and assign conversations to staff.
- **Interactions** – log additional contact attempts for leads or students; this keeps your communication history centralized.

![Account page – Login](/docs/images/announcement.png)

Guidelines:
- Use clear subject lines and consistent tone.
- Update email templates before large enrollment pushes or policy changes.
- Archive old announcements to keep the dashboard tidy.

---

## 13. Settings & Configuration

- **Branding** – upload logos, set primary/secondary colors, update school name. Preview the changes before saving to ensure legibility.
- **Dropdowns** – manage dynamic drop-down options used throughout the LMS (programs, statuses, interview outcomes). Update options carefully; removing values can affect existing records.
- **Notifications** – configure automated alerts (staff reminders, student updates). Toggle on/off and adjust recipients.
- **Todo Templates** – create reusable checklists. Specify steps, due dates, and assignable roles.
- **Admins** – view active admins, reset passwords, add new accounts, and deactivate old ones.
- **Required Documents** – define which documents appear in student checklists.
- **Signature Documents** – manage templates for electronic signatures and associated workflows.

![Account page – Login](/docs/images/branding.png)

Remember to document every change for audit trails.

---

## 14. Data Exports & Compliance

- **Reports → Export** – most reports include CSV exports. Filter the data first; exports respect your filters.
- **Attendance Reports** – export print-ready attendance logs per class or student. Include date range and instructor signatures if required.
- **Gradebook Print/Export** – produce records for accreditation reviews. Encourage teachers to lock in final grades before exporting.
- **Lead/Interactions Export** – capture marketing data for CRM integration.
- Store exports in secure, access-controlled locations (e.g., encrypted drives).

> [Add screenshot: Export CSV button]

Compliance checklist:
- Retain documents per regulatory requirements.
- Log decisions (approve/deny) in the system with notes.
- Use the audit trail when investigating changes.
- Coordinate with MD Tech leadership for retention schedules.
- Do not email sensitive data unless encrypted.

---

## 15. Troubleshooting & Support

Common issues:

- **Cannot find a user** – verify role filters (student vs. teacher). Use search in the relevant list.
- **Email not received** – check spam folders; ensure the email template is active; resend if necessary.
- **Calendar event missing** – confirm filters and the event’s target audience.
- **Certificate failed to send** – review server logs; ensure student email is correct; try resending.

If you cannot resolve an issue:

- Collect the error message, time of occurrence, and steps taken.
- Contact an MD Tech admin immediately (list available in the Admins page).
- For infrastructure problems, escalate to IT with relevant logs.
- Document the resolution in the appropriate ticketing system or internal notes for future reference.



---

## 16. Change Log

- **January 2025** – Added inline help icons, teacher resend functionality, and manuals.
- **December 2024** – Expanded calendar filters and interactions tracking.
- **October 2024** – Introduced reporting charts and advanced document workflows.

---

Need help beyond this manual? Reach out to an MD Tech administrator for guidance.
