# Career Advisor Interview System - Quick Reference

## For Students

### How to Schedule an Interview

1. Go to your dashboard
2. Click the green "Schedule Career Interview" button
3. Select a date from the calendar (only certain dates are available)
4. Select a time between 8 AM and 5 PM
5. Fill in your contact information
6. Choose what you want to discuss from the dropdown
7. Optionally add a brief summary
8. Upload your resume (PDF, Word, or Pages format)
9. Click "Schedule Interview"
10. You'll receive a confirmation email immediately
11. You'll get another email when your interview is confirmed with meeting details

### Interview Dates
- Interviews are only available on specific weekdays each month
- Usually around the 15th and 30th (or nearest weekday)
- Only Monday through Friday, 8 AM to 5 PM
- **Limited to 40 days out** from today's date

### What You Need
- ✅ Your resume (PDF, Word, or Pages - max 10MB)
- ✅ Phone number
- ✅ Clear idea of what you want to discuss

---

## For Administrators

### Viewing Scheduled Interviews

1. Go to Admin Dashboard
2. Scroll to "Other Tools" section
3. Click "Career Advisor Interviews"
4. Use tabs to filter: Upcoming / Pending / Confirmed / All

### Confirming an Interview

1. Find the interview in the list
2. Click "Send Confirmation Email" button
3. Enter the career advisor's name
4. Optionally add a meeting link (Zoom, Teams, etc.)
5. Click "Send Confirmation"
6. Student receives email with advisor details and meeting link

### Adding Meeting Link Later

1. Find confirmed interview
2. Click "Add Meeting Link"
3. Enter the meeting URL
4. Click "Add Link & Email Student"
5. Student receives email with the link

### Managing Interviews

**Available Actions:**
- **Send Confirmation** - Sends email with advisor name and meeting link
- **Add Meeting Link** - Updates and emails meeting link
- **Mark Complete** - Changes status to completed
- **Cancel** - Cancels the interview
- **Add Notes** - Internal notes for staff (not visible to students)

### Calendar Integration

All scheduled interviews automatically appear on your Admin Dashboard calendar with:
- Student name in title
- Date and time
- Interest area in description
- Click to go to full details

### Email Notifications Sent

The system automatically sends these emails:

1. **To Student (on submission):**
   - Confirms receipt
   - Shows date/time/topic
   - Mentions confirmation coming

2. **To Student (when you confirm):**
   - Confirms the interview
   - Shows advisor name
   - Includes meeting link (if provided)

3. **To Student (when you add meeting link):**
   - Just the meeting link
   - Date/time reminder

### Status Meanings

- 🟡 **Pending** - Awaiting confirmation from admin
- 🟢 **Confirmed** - Admin confirmed, student notified
- ⚫ **Completed** - Interview finished
- 🔴 **Cancelled** - Interview cancelled

---

## Quick Access URLs

**Student:**
- Scheduling Page: `/student/career-advisor`

**Admin:**
- Management Page: `/admin/career-advisor-interviews`
- Dashboard Link: Admin Dashboard → Other Tools → Career Advisor Interviews

---

## Interview Topics Available

Students can choose from these interest areas:
- General Career Guidance
- Resume Review
- Interview Preparation
- Job Search Strategies
- Networking & LinkedIn
- Salary Negotiation
- Career Change/Transition
- Industry Insights
- Other

---

## File Requirements

**Resume Upload:**
- Formats: PDF (.pdf), Word (.doc, .docx), Pages (.pages)
- Maximum Size: 10 MB
- Required: Yes

---

## Interview Schedule Rules

**Days:** Only weekdays near the 15th and 30th of each month (within 40 days)
- If 15th is a weekend → Uses nearest Friday (13th or 14th)
- If month-end is weekend → Uses nearest Friday (28th or 29th)
- Maximum 40 days out from current date

**Times:** 8:00 AM to 5:00 PM (in 1-hour increments)
- 8:00 AM
- 9:00 AM
- 10:00 AM
- 11:00 AM
- 12:00 PM
- 1:00 PM
- 2:00 PM
- 3:00 PM
- 4:00 PM

**Duration:** Approximately 45 minutes per interview

---

## Troubleshooting

### Student Issues

**Can't see any available dates?**
- Dates are automatically calculated up to 40 days ahead
- Only specific days of the month are available
- Contact admin if you need a special accommodation

**Resume won't upload?**
- Check file format (PDF, Word, or Pages only)
- Check file size (must be under 10MB)
- Try a different browser

**Didn't receive confirmation email?**
- Check spam folder
- Verify your email address is correct in your profile
- Contact admin to resend

### Admin Issues

**Interview not showing on calendar?**
- Refresh the calendar view
- Check the date range being displayed
- Verify the interview wasn't cancelled

**Can't send confirmation email?**
- Check student's email address in the interview details
- Verify SMTP settings are configured
- Check server logs for email errors

**Interview data not saving?**
- Check file permissions on `data/careerAdvisorInterviews.json`
- Verify disk space is available
- Check server logs for errors

---

## Best Practices

### For Students
1. Schedule at least 1 week in advance when possible
2. Upload an updated resume
3. Prepare specific questions beforehand
4. Test your meeting link before the interview
5. Join 5 minutes early

### For Admins
1. Confirm interviews within 24 hours of scheduling
2. Add meeting links as soon as possible
3. Send reminder emails 24 hours before (manual for now)
4. Mark as complete after interview occurs
5. Add notes about outcomes or follow-up needed
6. Review upcoming interviews at start of each week

---

## Support

For technical issues or questions:
- Students: Contact your advisor or admin
- Admins: Check server logs at `/logs` or contact IT support

---

## Data Location

All interview data is stored in:
```
/data/careerAdvisorInterviews.json
```

Resume files are stored in:
```
/uploads/resume-[timestamp]-[random].[ext]
```

---

## Integration Points

This feature integrates with:
- ✅ Student Dashboard
- ✅ Admin Dashboard
- ✅ Admin Calendar
- ✅ Student Interactions/Lead Tracking
- ✅ Email System
- ✅ File Upload System

---

Last Updated: November 16, 2025
