const db = require('./db');

async function init() {
  await db.query(`CREATE TABLE IF NOT EXISTS mdtslms_mentors (
    id INT AUTO_INCREMENT PRIMARY KEY,
    role VARCHAR(120) NULL,
    name VARCHAR(255) NOT NULL,
    phone VARCHAR(100) NULL,
    email VARCHAR(255) NULL,
    notes TEXT NULL,
    createdAt DATETIME DEFAULT CURRENT_TIMESTAMP
  )`);
  await db.query(`CREATE TABLE IF NOT EXISTS mdtslms_mentor_notes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    mentorId INT NOT NULL,
    note TEXT NOT NULL,
    createdAt DATETIME DEFAULT CURRENT_TIMESTAMP,
    INDEX(mentorId),
    FOREIGN KEY (mentorId) REFERENCES mdtslms_mentors(id) ON DELETE CASCADE
  )`);
}
init().catch(console.error);

async function list() {
  const [rows] = await db.query('SELECT * FROM mdtslms_mentors ORDER BY name ASC');
  const [notes] = await db.query('SELECT * FROM mdtslms_mentor_notes ORDER BY createdAt DESC');
  const byMentor = new Map();
  notes.forEach(n => { const a = byMentor.get(n.mentorId) || []; a.push(n); byMentor.set(n.mentorId, a); });
  return rows.map(m => ({ ...m, notes: byMentor.get(m.id) || [] }));
}

async function create({ role, name, phone, email, notes }) {
  const [res] = await db.query(
    'INSERT INTO mdtslms_mentors (role, name, phone, email, notes) VALUES (?,?,?,?,?)',
    [role || null, name, phone || null, email || null, notes || null]
  );
  return { id: res.insertId };
}

async function remove(id) { await db.query('DELETE FROM mdtslms_mentors WHERE id=?', [id]); return true; }

async function addNote(mentorId, note) {
  const [res] = await db.query('INSERT INTO mdtslms_mentor_notes (mentorId, note) VALUES (?,?)', [mentorId, note]);
  return { id: res.insertId };
}

module.exports = { list, create, remove, addNote };

