# Schedule Builder Feature

## Overview

The Schedule Builder is a comprehensive scheduling tool for administrators to plan courses, manage teacher availability, and visualize class schedules across different cohorts, locations, and instructors.

## Features

### 1. Schedule Builder Main Page (`/admin/schedule-builder`)

A visual calendar interface for planning and managing course sessions.

**Key Features:**
- **Multiple View Modes:**
  - **Month View**: Traditional calendar showing all sessions in a monthly grid
  - **Week View**: Detailed hourly view for the current week
  - **Gantt View**: Timeline view grouped by cohort for long-term planning

- **Color-Coded Sessions**: Each session can be assigned a color for easy visual identification

- **Program Tracks**: Define program tracks (e.g., "Cyber II Track") with custom colors to categorize courses

- **Conflict Detection**: Automatic detection of teacher double-booking when scheduling sessions

- **Filter Options**: Filter schedule by teacher or location

### 2. Teacher Availability (`/admin/schedule-builder/teacher-availability`)

Manage each teacher's available time slots to prevent double-booking.

**Features:**
- Weekly recurring availability slots per teacher
- Quick templates (Full-time M-F 9-5, Part-time M-W-F)
- Easy add/remove of availability slots
- Copy schedule to clipboard

### 3. Add Session Form

Schedule new course sessions with the following fields:
- **Cohort Name**: WIOA, month name, or class section number
- **Course Name**: The course being taught
- **Program Track**: Optional categorization with custom colors
- **Session Date(s)**: Single or recurring sessions
- **Start/End Time**: Class timing
- **Teacher**: Assigned instructor (with conflict checking)
- **Location**: Online (lecture) + optional physical location
- **Color**: Visual identification in the calendar
- **Notes**: Additional information

**Recurring Sessions:**
- Generate multiple sessions at once
- Choose pattern: Daily, Weekly, or Bi-Weekly
- Select specific days of the week
- Set end date

### 4. Export Functionality

Export schedules to Excel or CSV with various filters:
- **Export Types:**
  - All Sessions
  - By Teacher
  - By Cohort
  - By Course

- **Date Range Filter**: Optional start/end dates

- **Output Formats:**
  - Excel (.xlsx) - Full formatting
  - CSV - Simple format for email/sharing

**Columns in Export:**
1. Cohort
2. Course
3. Date
4. Start Time
5. End Time
6. Teacher
7. Location (Online)
8. Location (Physical)
9. Program Track
10. Notes

## Database Tables

The feature uses the following MySQL tables:

### `mdtslms_teacher_availability`
Stores teacher availability slots.
- `teacherId`: Reference to teacher
- `dayOfWeek`: 0-6 (Sunday-Saturday)
- `startTime`, `endTime`: Available hours
- `isRecurring`: Whether this is a weekly recurring slot
- `specificDate`: For non-recurring availability

### `mdtslms_scheduled_sessions`
Stores scheduled course sessions.
- `cohortName`: WIOA, month, or section number
- `courseId`, `courseName`: Course information
- `sessionDate`: Date of the session
- `startTime`, `endTime`: Session timing
- `teacherId`: Assigned teacher
- `locationOnline`: Boolean for online component
- `locationPhysical`: Physical location name
- `colorCode`: Hex color for visualization
- `programTrack`: Program track name

### `mdtslms_program_tracks`
Stores program track definitions.
- `name`: Track name (e.g., "Cyber II Track")
- `colorCode`: Hex color for the track
- `description`: Optional description

### `mdtslms_locations`
Stores location options.
- `name`: Location name
- `address`: Full address (optional)
- `isOnline`: Boolean flag

**Default Locations:**
- Online
- Newport News
- Fredericksburg
- Virginia Beach
- Maryland

### `mdtslms_teacher_time_off`
Stores teacher vacation and leave dates.
- `teacherId`: Reference to teacher
- `startDate`: Start of time-off period
- `endDate`: End of time-off period (inclusive)
- `reason`: Optional reason (e.g., "Vacation", "Medical Leave")

### `mdtslms_holidays`
Stores organization-wide holidays.
- `name`: Holiday name (e.g., "Christmas Day", "Thanksgiving")
- `date`: Date of the holiday
- `recurring`: Boolean - if true, repeats every year on the same month/day

## API Endpoints

### Sessions
- `GET /admin/schedule-builder/sessions` - Get all sessions (with optional filters)
- `POST /admin/schedule-builder/sessions` - Create a session
- `POST /admin/schedule-builder/sessions/bulk` - Create multiple sessions
- `PUT /admin/schedule-builder/sessions/:id` - Update a session
- `DELETE /admin/schedule-builder/sessions/:id` - Delete a session

### Teacher Availability
- `GET /admin/schedule-builder/teacher-availability/:teacherId` - Get teacher's availability
- `POST /admin/schedule-builder/teacher-availability/:teacherId` - Set teacher's availability
- `POST /admin/schedule-builder/availability-slot` - Add single slot
- `DELETE /admin/schedule-builder/availability-slot/:id` - Remove slot

### Program Tracks
- `GET /admin/schedule-builder/program-tracks` - List all tracks
- `POST /admin/schedule-builder/program-tracks` - Create track
- `PUT /admin/schedule-builder/program-tracks/:id` - Update track
- `DELETE /admin/schedule-builder/program-tracks/:id` - Delete track

### Locations
- `GET /admin/schedule-builder/locations` - List all locations
- `POST /admin/schedule-builder/locations` - Create location

### Conflict Detection
- `POST /admin/schedule-builder/check-conflicts` - Check for scheduling conflicts

### Time-Off Management
- `GET /admin/schedule-builder/time-off` - Get all time-off entries (or filter by teacherId)
- `POST /admin/schedule-builder/time-off` - Add teacher time-off
- `DELETE /admin/schedule-builder/time-off/:id` - Remove time-off entry

### Holiday Management
- `GET /admin/schedule-builder/holidays` - Get all holidays (with optional date range)
- `POST /admin/schedule-builder/holidays` - Add holiday
- `DELETE /admin/schedule-builder/holidays/:id` - Remove holiday

### Week Availability Check
- `GET /admin/schedule-builder/week-availability` - Check a teacher's availability for a specific week (accounts for time-off and holidays)

### Export
- `GET /admin/schedule-builder/export` - Export schedule (CSV or JSON for Excel)

## Quick Start

1. **Access Schedule Builder**: Navigate to Admin Dashboard → Quick Actions → Schedule Builder

2. **Set Up Teacher Availability**: Click "Teacher Availability" to define when each teacher is available to teach

3. **Set Up Holidays**: On the Teacher Availability page, scroll down to add organization holidays (Thanksgiving, Christmas, etc.)

4. **Add Time-Off**: When teachers request vacation or leave, add their time-off dates on the Teacher Availability page

5. **Create Program Tracks**: Add program tracks with colors to categorize your courses

6. **Add Sessions**: Use the form on the right side to schedule individual or recurring sessions

7. **View Schedule**: Use the calendar views to visualize and manage your schedule - holidays and time-off will be highlighted

8. **Export**: Use the Export panel to generate Excel/CSV files for sharing

## Tips

- Use distinct colors for different program tracks to easily identify courses
- Set up teacher availability before scheduling to catch conflicts early
- **Set up holidays at the start of each year** - recurring holidays only need to be entered once
- **Add teacher time-off as soon as you know** - the system will warn you if you try to schedule them during their leave
- Use recurring sessions for courses that meet regularly
- Export by teacher to give instructors their personal schedules
- Use the Gantt view for long-term planning across multiple cohorts
- **Holidays appear with a red badge** on the calendar - avoid scheduling on these dates
- **Time-off shows with an orange badge** indicating how many teachers are unavailable

## Week-Specific Scheduling

The schedule builder now supports week-specific scheduling that accounts for:

### Holidays
- Define organization holidays on the Teacher Availability page
- Mark holidays as "recurring" to have them repeat every year (e.g., Christmas is always Dec 25)
- One-time holidays (like a specific training day) won't repeat
- Holidays appear highlighted in red on the calendar
- When scheduling a session on a holiday, you'll see a warning

### Teacher Time-Off / Vacation
- Add time-off periods for individual teachers
- Include optional reason (Vacation, Medical Leave, Personal, etc.)
- Time-off can span multiple days or a single day
- The system automatically checks if a teacher is on leave when scheduling
- Calendar shows how many teachers are off on any given day

### How It Works
When you schedule a session:
1. The system checks if it's a holiday - shows a red warning
2. Checks if the selected teacher is on leave - shows an orange warning  
3. Checks for conflicts with other scheduled sessions - shows the existing conflict
4. You can still proceed with scheduling if needed (e.g., makeup sessions)

