# PDF-to-Image Conversion for Drag-and-Drop Fields

## Changes Made

### 1. Updated PDF Conversion Utility (`utils/pdfToImage.js`)
- **Changed approach**: Now uses `pdf-poppler` library for reliable server-side PDF-to-PNG conversion
- **Key functions**:
  - `getPdfPageCount(pdfPath)` - Gets number of pages in PDF using pdf-lib
  - `convertPdfPageToImage(pdfPath, pageNumber)` - Converts a specific PDF page to PNG image
  - Uses temporary directory for conversion
  - High quality scale (2048) for sharp rendering
  - Automatic cleanup after conversion

### 2. Updated Route (`routes/documentSigning.js`)
- **Route**: `GET /document-signing/pdf-page/:documentId/:pageNumber`
- **Now serves**: PNG images instead of PDF pages
- **Headers**: 
  - `Content-Type: image/png`
  - `Cache-Control: public, max-age=86400` (1 day cache)

### 3. Updated View (`views/admin_signature_document_edit.ejs`)

**Changed PDF display from object to img tag:**
```html
<img src="/document-signing/pdf-page/<%= document.id %>/1" 
     alt="Document Page 1"
     id="pdfImage"
     style="width: 100%; display: block; user-select: none; pointer-events: none;"
     draggable="false">
```

**Fixed page button behavior:**
- Removed `disabled` attribute from page buttons
- Added `active` class to first page button
- Buttons now stay enabled and just change appearance when clicked

**Added CSS for active page buttons:**
```css
.page-btn.active {
  background-color: var(--primary-color);
  color: white;
  border-color: var(--primary-color);
}
```

**Updated page switching JavaScript:**
- Changes `pdfImage.src` to load new page image
- Updates `active` class on buttons (doesn't disable)
- Calls `loadFieldsForPage()` to show only fields for that page

### 4. Field Editor JavaScript (`public/js/signature-field-editor.js`)
- Already properly configured to work with image element
- Calculates drop positions relative to pdf-page container
- Prevents default drag on image element
- Overlays fields as absolutely positioned divs

## How It Works Now

1. **PDF Upload**: Admin uploads a PDF document
2. **Page Display**: When editing, each page is converted to PNG on-demand
3. **Caching**: Images are cached by browser for 24 hours (fast page switching)
4. **Drag & Drop**: 
   - Drag field types from left sidebar
   - Drop onto PNG image
   - Fields are overlaid as HTML divs with absolute positioning
   - Position calculated as percentages for responsive scaling
5. **Multi-Page Navigation**:
   - Click page buttons to switch between pages
   - Image source updates to show different page
   - Only fields for current page are displayed
   - All buttons stay enabled

## Dependencies

- `pdf-poppler`: Node.js wrapper for Poppler PDF rendering tools
- `pdf-lib`: For reading PDF metadata (page count)

**Note**: `pdf-poppler` requires Poppler utilities to be installed on the system:
- **macOS**: `brew install poppler`
- **Ubuntu/Debian**: `apt-get install poppler-utils`
- **Windows**: Download from https://github.com/oschwartz10612/poppler-windows/releases/

## Testing
1. Navigate to Document Signing → Edit a document
2. You should see the PDF rendered as a PNG image
3. Drag field types (Signature, Text, etc.) from the left sidebar
4. Drop them onto the document image
5. Fields should appear where you drop them
6. Click page buttons to switch between pages (buttons should stay enabled)
7. Fields should only show for their respective pages

## Benefits

✅ **Reliable conversion**: pdf-poppler is battle-tested and stable  
✅ **High quality**: 2048 scale produces sharp, readable images  
✅ **Fast**: Browser caching prevents repeated conversions  
✅ **Works everywhere**: Just needs Poppler installed on server  
✅ **Interactive overlays**: PNG images allow perfect HTML element positioning  
✅ **Multi-page support**: Easy page switching with field filtering  
