# Local Libraries Setup

This project uses local copies of Tailwind CSS and D3.js to avoid external CDN dependencies.

## Files

- **`public/css/tailwind.css`** - Compiled Tailwind CSS (142KB minified)
- **`public/js/d3.v7.min.js`** - D3.js v7.8.5 (273KB)
- **`tailwind.config.js`** - Tailwind configuration
- **`.tailwindcss-cli`** - Tailwind standalone CLI binary (not in git)
- **`build-tailwind.sh`** - Script to rebuild Tailwind CSS

## Rebuilding Tailwind CSS

If you modify views or need to update Tailwind utilities, run:

```bash
./build-tailwind.sh
```

Or manually:

```bash
./.tailwindcss-cli -i ./public/css/tailwind-source.css -o ./public/css/tailwind.css --minify
```

## Initial Setup (if files are missing)

### Download Tailwind CLI

```bash
# For macOS ARM64 (M1/M2/M3)
curl -sLO https://github.com/tailwindlabs/tailwindcss/releases/download/v3.4.1/tailwindcss-macos-arm64
chmod +x tailwindcss-macos-arm64
mv tailwindcss-macos-arm64 .tailwindcss-cli

# For macOS Intel
curl -sLO https://github.com/tailwindlabs/tailwindcss/releases/download/v3.4.1/tailwindcss-macos-x64
chmod +x tailwindcss-macos-x64
mv tailwindcss-macos-x64 .tailwindcss-cli

# For Linux
curl -sLO https://github.com/tailwindlabs/tailwindcss/releases/download/v3.4.1/tailwindcss-linux-x64
chmod +x tailwindcss-linux-x64
mv tailwindcss-linux-x64 .tailwindcss-cli
```

### Download D3.js

```bash
curl -o public/js/d3.v7.min.js https://cdn.jsdelivr.net/npm/d3@7.8.5/dist/d3.min.js
```

### Build Tailwind CSS

```bash
./build-tailwind.sh
```

## Benefits

- ✅ No external CDN dependencies
- ✅ Works offline
- ✅ Faster page loads (no external requests)
- ✅ No third-party tracking
- ✅ Consistent versions across deployments

## References

- [Tailwind CSS](https://tailwindcss.com)
- [D3.js](https://d3js.org)
