# Career Services Quick Reference Guide

## Accessing Career Services
1. Navigate to any student's profile page as Admin or Teacher
2. Scroll to the bottom of the page
3. Find the **💼 Career Services** section
4. Click on the tabs to access different features

---

## 📅 Scheduling Interviews

### To Schedule an Interview:
1. Click **Interviews** tab
2. Click **Schedule Interview** button
3. Fill in the form:
   - **Date**: Required - Select interview date
   - **Time**: Optional - Enter time (HH:MM format)
   - **Type**: Select from dropdown (Career Counseling, Mock Interview, etc.)
   - **Status**: Choose Scheduled, Completed, or Cancelled
   - **Notes**: Optional - Add any relevant details
4. Click **Schedule**

### To Edit an Interview:
1. Find the interview in the table
2. Click the pencil icon (✏️)
3. Modify any fields
4. Click **Update**

### To Delete an Interview:
1. Find the interview in the table
2. Click the trash icon (🗑️)
3. Confirm deletion

---

## 📝 Adding Career Notes

### To Add a Note:
1. Click **Notes** tab
2. Click **Add Note** button
3. Fill in:
   - **Title**: Optional - Brief description
   - **Content**: Required - Detailed note text
4. Click **Add Note**

**Note automatically includes:**
- Your name as the author
- Current date and time

### To Edit a Note:
1. Find the note in the list
2. Click the pencil icon (✏️)
3. Modify title or content
4. Click **Update**

### To Delete a Note:
1. Find the note in the list
2. Click the trash icon (🗑️)
3. Confirm deletion

---

## 📄 Managing Documents

### To Upload a Document:
1. Click **Documents** tab
2. Click **Choose File** and select a file
   - Supported: PDF, DOC, DOCX, JPG, PNG
   - Max size: 10MB per file
3. Click **Upload**

**Best Practices:**
- Use clear filenames (e.g., "JohnDoe_Resume_2025.pdf")
- Upload current versions only
- Common documents: resumes, cover letters, reference letters

### To Download a Document:
1. Find the document in the table
2. Click the download icon (⬇️)
3. File will open in a new tab or download

### To Delete a Document:
1. Find the document in the table
2. Click the trash icon (🗑️)
3. Confirm deletion
4. Both the record AND physical file will be removed

---

## 💼 Recording Employment Surveys

### To Record Survey Results (First Time):
1. Click **Employment Survey** tab
2. Click **Record Employment Survey Results**
3. Fill in the comprehensive form:
   - **Employment Status**: Required - Select from dropdown
   - **Job Title**: Enter current position
   - **Employer**: Company/organization name
   - **Employment Start Date**: When they started the job
   - **Salary Range**: Select range (optional but helpful)
   - **Related to Training**: Yes/No - Important for compliance!
   - **Survey Date**: Required - When you collected this data
   - **Additional Notes**: Any context or details
4. Click **Save Survey**

### To Edit Survey Results:
1. View existing survey in the Employment Survey tab
2. Click **Edit Survey Results**
3. Modify any fields as needed
4. Click **Update Survey**

### Employment Status Options:
- **Employed Full-Time**: 30+ hours/week
- **Employed Part-Time**: Less than 30 hours/week
- **Self-Employed**: Running own business
- **Unemployed - Seeking**: Actively job searching
- **Unemployed - Not Seeking**: Not looking for work
- **Continuing Education**: Pursuing further education
- **Military**: Active military service
- **Other**: Explain in notes

---

## 🎯 Tips for Career Services

### Best Practices:
1. **Document Everything**: Record all interactions, even brief ones
2. **Be Specific**: Include details in notes and interview records
3. **Follow Up**: Schedule follow-up interviews as needed
4. **Keep Documents Current**: Remove outdated versions
5. **Complete Surveys**: Required for SCHEV/WIOA/VA compliance

### When to Record Employment Surveys:
- At graduation
- 6 months after graduation
- 1 year after graduation
- During annual alumni surveys
- When student reports job placement

### Interview Type Guidelines:
- **Career Counseling**: General career guidance, goal setting
- **Mock Interview**: Practice interview sessions
- **Job Search Support**: Help with applications, job boards
- **Resume Review**: Feedback on resume/cover letter
- **Other**: Networking events, job fairs, etc.

---

## ⚠️ Important Notes

### Compliance Requirements:
- Employment surveys are **mandatory** for SCHEV/WIOA/VA reporting
- Record survey date accurately for audit trails
- "Related to Training" field is critical for outcomes reporting
- Keep documentation for minimum 5 years

### Data Privacy:
- Only Admin and Teacher roles can view this section
- Students cannot see their career services records
- Salary information is optional to protect privacy
- All actions are logged with username and timestamp

### Troubleshooting:
- **Upload fails**: Check file size (max 10MB) and type
- **Can't delete**: Ensure you have proper permissions
- **Changes not saving**: Check your internet connection
- **Missing data**: Refresh the page

---

## 📊 Using Data for Reports

### Common Reports Needed:
1. **Employment Rate**: % of students employed after graduation
2. **Training-Related Employment**: % in field-related jobs
3. **Salary Outcomes**: Average salary ranges
4. **Interview Activity**: Number of counseling sessions per student
5. **Document Completion**: Students with resumes on file

### Export Recommendations:
- Keep CSV/Excel exports for compliance audits
- Document survey collection dates
- Track response rates for follow-up
- Generate reports by cohort/graduation year

---

## 🆘 Need Help?

If you encounter issues:
1. Refresh the page and try again
2. Clear your browser cache
3. Check that you're logged in as Admin or Teacher
4. Contact IT support with specific error messages
5. Provide student ID and timestamp of the issue

---

**Last Updated**: November 21, 2025
**Feature Version**: 1.0
