/**
 * PDF Utility Functions
 * Server-side PDF handling (page count only)
 * Actual rendering happens in browser using PDF.js
 */

const fs = require('fs').promises;
const { PDFDocument } = require('pdf-lib');

/**
 * Get the number of pages in a PDF
 * @param {string} pdfPath - Path to PDF file
 * @returns {Promise<number>} Number of pages
 */
async function getPdfPageCount(pdfPath) {
  try {
    const pdfBytes = await fs.readFile(pdfPath);
    const pdfDoc = await PDFDocument.load(pdfBytes);
    return pdfDoc.getPageCount();
  } catch (error) {
    console.error('Error getting PDF page count:', error);
    return 1;
  }
}

module.exports = {
  getPdfPageCount
};
