const fs = require('fs');
const path = require('path');
const branding = require('../branding.json');

const templatesPath = path.join(__dirname, '../data/emailTemplates.json');
let templates = {};

function load() {
  try {
    const data = fs.readFileSync(templatesPath, 'utf8');
    templates = JSON.parse(data);
  } catch (e) {
    templates = {};
  }
}

function saveTemplate(key, tpl) {
  templates[key] = tpl;
  fs.writeFileSync(templatesPath, JSON.stringify(templates, null, 2));
}

function wrapHtml(subject, bodyHtml){
  const logo = branding?.primaryLogo || '';
  const school = branding?.schoolName || 'MD Technical School';
  // Ensure at least a lightweight intro/footer around body
  const intro = `<p style="margin:0 0 12px;">${school}</p>`;
  const outro = `<p style="margin:12px 0 0; color:#64748b; font-size:12px;">Thank you for choosing ${school}. We’re here to help with any questions.</p>`;
  return `
  <div style="background:#f6f8fb; padding:24px; font-family:Segoe UI,Roboto,Arial,sans-serif;">
    <div style="max-width:680px; margin:0 auto; background:#ffffff; border:1px solid #e5e7eb; border-radius:12px; overflow:hidden;">
    
      <div style="padding:20px;">
        ${intro}
        ${bodyHtml}
        ${outro}
      </div>
    </div>
  </div>`;
}

function render(key, vars = {}) {
  if (!Object.keys(templates).length) load();
  const tpl = templates[key] || { subject: '', html: '' };
  let subject = tpl.subject || '';
  let html = tpl.html || '';
  for (const [k, v] of Object.entries(vars)) {
    const re = new RegExp(`{{${k}}}`, 'g');
    subject = subject.replace(re, v);
    html = html.replace(re, v);
  }
  const wrapped = wrapHtml(subject, html);
  const text = wrapped.replace(/<[^>]*>/g, '');
  return { subject, html: wrapped, text };
}

load();

module.exports = { render, saveTemplate, load, templates, wrapHtml };
