const pool = require('../models/db');

async function setupMessagesTable() {
  try {
    console.log('Setting up mdtslms_messages table...');
    
    // Create messages table
    await pool.query(`
      CREATE TABLE IF NOT EXISTS mdtslms_messages (
        id INT AUTO_INCREMENT PRIMARY KEY,
        senderId INT NOT NULL,
        recipientId INT NOT NULL,
        subject VARCHAR(255),
        body TEXT,
        sentAt TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        readAt TIMESTAMP NULL,
        INDEX idx_sender (senderId),
        INDEX idx_recipient (recipientId),
        INDEX idx_sent_at (sentAt)
      )
    `);
    
    console.log('✅ mdtslms_messages table created successfully');
    process.exit(0);
  } catch (error) {
    console.error('❌ Error setting up messages table:', error);
    process.exit(1);
  }
}

setupMessagesTable();
