/**
 * Initialize Document Signing Database Tables
 * Run this script once to create all required tables
 */

const signatureDocumentModel = require('../models/signatureDocumentModel');

async function initialize() {
  console.log('🔧 Initializing document signing database tables...\n');
  
  try {
    await signatureDocumentModel.initializeTables();
    console.log('\n✅ SUCCESS! All document signing tables have been created.');
    console.log('\nYou can now use the document signing feature.');
    console.log('Navigate to a student profile and click "Document Signing" to get started.\n');
    process.exit(0);
  } catch (error) {
    console.error('\n❌ ERROR: Failed to initialize tables');
    console.error(error);
    console.log('\nPlease check your database connection and try again.\n');
    process.exit(1);
  }
}

initialize();
