const fs = require('fs');
const path = require('path');

const simsDir = '/Users/backupadmin/Documents/GitHub/LMS/sims';

// Get all simulation directories
const simDirs = fs.readdirSync(simsDir).filter(item => {
  const fullPath = path.join(simsDir, item);
  return fs.statSync(fullPath).isDirectory();
});

console.log(`Found ${simDirs.length} simulation directories`);

let updatedCount = 0;
let errorCount = 0;
let skippedCount = 0;

simDirs.forEach(simDir => {
  const indexPath = path.join(simsDir, simDir, 'index.html');
  
  if (!fs.existsSync(indexPath)) {
    console.log(`⚠️  No index.html in ${simDir}`);
    return;
  }
  
  try {
    let content = fs.readFileSync(indexPath, 'utf8');
    let modified = false;
    
    // Remove bcc.jpg background from body
    if (content.includes("url('../bcc.jpg')")) {
      content = content.replace(
        /body\{\s*background:\s*var\(--bg\)\s*url\(['"]\.\.\/bcc\.jpg['"]\)[^;]*;/g,
        'body{ background: var(--bg);'
      );
      modified = true;
    }
    
    // Remove Build/*.jpg backgrounds from canvas and replace with gradient
    const canvasBgRegex = /#unity-canvas\{([^}]*?)background:\s*url\(['"]Build\/[^'"]+\.jpg['"]\)[^;]*;([^}]*?)\}/g;
    if (canvasBgRegex.test(content)) {
      content = content.replace(
        canvasBgRegex,
        '#unity-canvas{$1background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);$2}'
      );
      modified = true;
    }
    
    // Fix CheckDate function to handle null values (only in files that have CheckDate)
    if (content.includes('function CheckDate(pinval)') && !content.includes('if (!pinval || pinval.length < 4)')) {
      content = content.replace(
        /(function CheckDate\(pinval\)\{[\s\n]*)(const dx = new Date\(\);)/,
        `$1// Check if pinval is null or undefined
                                            if (!pinval || pinval.length < 4) {
                                              return true; // Allow access if no key is set
                                            }
                                            
                                            $2`
      );
      modified = true;
    }
    
    if (modified) {
      fs.writeFileSync(indexPath, content, 'utf8');
      console.log(`✓ Updated ${simDir}`);
      updatedCount++;
    } else {
      console.log(`⚪ ${simDir} - no changes needed`);
      skippedCount++;
    }
    
  } catch (error) {
    console.error(`✗ Error updating ${simDir}:`, error.message);
    errorCount++;
  }
});

console.log(`\n✓ Successfully updated ${updatedCount} files`);
console.log(`⚪ Skipped ${skippedCount} files (no changes needed)`);
if (errorCount > 0) {
  console.log(`✗ ${errorCount} files had errors`);
}
