const db = require('../models/db');

async function checkColumns() {
  try {
    const [cols] = await db.query('DESCRIBE mdtslms_users');
    console.log('\nColumns in mdtslms_users table:');
    console.log('--------------------------------');
    cols.forEach(c => {
      console.log(`${c.Field} (${c.Type})`);
    });
    process.exit(0);
  } catch (error) {
    console.error('Error:', error);
    process.exit(1);
  }
}

checkColumns();
