# MDTS Teacher Playbook

Welcome to the MD Technical School Learning Management System (LMS). This guide walks you through every tool available to instructors so you can run classes smoothly, track student progress, and stay on top of communication.

**Last Updated:** December 2024 | **Version:** 2.0

---

## Table of Contents

1. [Access & Profile](#1-access--profile)
2. [Teacher Dashboard](#2-teacher-dashboard)
3. [Class Workspaces](#3-class-workspaces)
    - [Overview tab](#overview-tab)
    - [Schedule tab](#schedule-tab)
    - [Class Checklist](#class-checklist)
4. [Learning Resources](#4-learning-resources)
    - [Lectures](#lectures)
    - [Simulations](#simulations)
    - [Assignments](#assignments)
    - [Resource Libraries](#resource-libraries)
5. [Assessments & Tests](#5-assessments--tests)
6. [Grading & Student Progress](#6-grading--student-progress)
7. [Attendance Tracking](#7-attendance-tracking)
8. [Student Management](#8-student-management)
9. [Communicating with Students](#9-communicating-with-students)
10. [Calendar & Events](#10-calendar--events)
11. [Reports & Downloads](#11-reports--downloads)
12. [Teacher Utilities](#12-teacher-utilities)
13. [Account Settings](#13-account-settings)
14. [Best Practices & Tips](#14-best-practices--tips)
15. [Troubleshooting & FAQ](#15-troubleshooting--faq)
16. [Change Log](#16-change-log)

---

## 1. Access & Profile

![Image](/docs/images/Teacher/TeacherLogin.png)

This section walks you through logging in and setting up your profile so students see the right information from day one.

### Sign in (first time and returning)

1. Navigate to the LMS login page provided by MD Technical School.
2. Enter the **username** and **temporary password** from your welcome email.
3. On first login, you can click on account in the upper right hand corner
![Image](/docs/images/Teacher/account.png)
   - On the right side of the screen you can change your current password.
   ![Image](/docs/images/Teacher/changepassword.png)
4. Log out and log back in using your new password to confirm everything works.

**If you can’t log in:**
- Make sure **Caps Lock** is off.
- Try copying/pasting your temporary password directly from the email.
- If needed, click **Forgot Password** on the login page and follow the reset instructions.
- If no reset email arrives within a few minutes, contact an admin.

### Update your profile

Keeping your profile updated helps students know who you are and how to reach you.

1. Click **Account** in the top navigation.
2. Review and edit your personal information:
   - **Name / Display name**
   - **Contact email** (students see this when you message them)
3. Upload an optional **profile photo**:
   - Click the photo area or **Upload Photo**.
   - Choose a clear headshot if possible.
4. Upload your **digital signature**:
   - Used for certificates and official documents.
   - A transparent PNG works best, or you can digitally sign
5. Add external resource links (Teacher Links), such as:
   - Class website
   - Office hours booking link
   - Zoom room / virtual classroom
6. Click **Save** to apply changes.

![Image](/docs/images/TeacherAccount.png)

> **Tip:** Review your profile before each term starts so students always see up-to-date contact info and links.

---

## 2. Teacher Dashboard

The dashboard is your command center and is accessible anytime from **Home**.

![Image](/docs/images/teacherdash.png)

### Quick actions

Use the quick actions at the top of your dashboard for common tasks:

- **Topic Helper** – Open this when you’re planning lessons or remediation:
  1. Click **Topic Helper**.
  2. Type the topic you’re teaching (e.g., “Network Security Basics”).
  3. Choose what you want: outline, examples, analogies, questions, etc.
  4. Copy the useful parts directly into your materials.

- **Reports** – For grade and progress summaries:
  1. Click **Reports**.
  2. Choose the report type (gradebook, attendance, class summary, etc.).
  3. Download or print as needed.

- **Account** – To quickly adjust your personal settings (photo, signature, Teacher Links, password):
  1. Click **Account**.
  2. Update any fields you need.
  3. Save changes.

Look for the `?` icons next to buttons—hovering or clicking will explain what each action does.

### My Classes panel

The **My Classes** panel shows every class assigned to you.

For each class card, you can:

- See the **meeting pattern** (days/times).
- Click shortcuts to:
  - **Lectures**
  - **Simulations**
  - **Tests**
- Click the class title (or a **Manage**/workspace button) to open the full **Class Workspace**.
- Use the `?` icon on the card if you’re not sure what a button does.

Use this panel when:
- You want to quickly jump into a specific class.
- You’re checking today’s teaching load or meeting times.

### Weekly schedule (calendar)

The calendar gives you a visual timeline of your upcoming sessions.

- **To open a class from the calendar:**
  1. Find the event for your class.
  2. Click it to jump directly to the class workspace.

- **To change the view:**
  - Use the view options (e.g., Week / Month) to zoom in or out.
  - On smaller screens, use the dropdown to switch views.

> **Tip:** If class times don’t look right here, check and adjust them in the **Schedule** tab for that class workspace.

---

## 3. Class Workspaces

Open a class from **My Classes** or the **Teacher → Classes** page.

Each class workspace is where you manage content, attendance, tests, and grades for that class.

![Image](/docs/images/Teacher/OverallClass.png)

### How to open a class workspace

1. From **My Classes**, click the class card or its **Manage** button.
2. Or, from the left navigation, go to **Teacher → Classes** and select the class.
3. Or, click a class event from the **dashboard calendar**.

Once inside, you’ll see multiple tabs (Overview, Schedule, Lectures, Simulations, Assignments, Tests, Gradebook, Attendance, etc.), each with its own purpose.

---

### Overview tab

Use the **Overview** tab to orient students to your course.

**What to include:**
- A short course description (what the class is about).
- Key learning objectives.
- Major milestones (first exam, final project, midterm, etc.).
- Any required materials.

**How to update:**
1. Go to the **Overview** tab.
2. Click **Edit** (if available).
3. Update the course summary and important information.
4. Click **Save**.

Students see this on their dashboards, so keep it concise and updated.

---

### Class Checklist

Use the **Class Checklist** to track preparatory tasks or special class needs.

**Typical uses:**
- Pre-class prep (print labs, confirm room, charge devices).
- Field trip tasks (permission forms, bus confirmations).
- Equipment needs (check laptops, confirm simulation accounts).

**To manage checklist items:**

1. Open the **Class Checklist** area in the workspace.
2. Click **Add Item**.
3. Enter a clear task name (e.g., “Upload Week 2 slides”).
4. Click **Save**.

**To mark tasks complete:**
- Check the checkbox next to the item when you finish it.

![Image](/docs/images/Teacher/ClassChecklist.png)

> **Tip:** Use this checklist together with co-teachers so everyone can see what’s done and what’s pending.

---

## 4. Learning Resources

Learning resources are where you attach everything students will read, watch, or interact with.

---

### Lectures

![Image](/docs/images/lectures.png)

Use **Lectures** to share slide decks, videos, notes, or any primary content for class.

**To add a lecture:**

1. Open the class workspace.
2. Click the **Lectures** tab.
3. Click **Add Lecture**.
4. Fill in:
   - **Title** (e.g., “Week 1: Introduction to Routing”).
   - **Optional date** (when you plan to cover it).
   - **URL or file link** to the slides, video, or handout.
5. Click **Save**.

**To use the Lecture Library:**

1. In the **Lectures** tab, click **Choose from Lecture Library**.
2. Browse or search for the lecture you want.
3. Select it and confirm.
4. Save your changes.

> **Tip:** Use consistent naming—e.g., “Week X: Topic Name” so students always know where they are in the course.

---

### Simulations

![Image](/docs/images/sims.png)  
![Image](/docs/images/simex.png)

Simulations are interactive practice activities for hands-on learning.

**To add a simulation:**

1. Go to the class workspace → **Simulations** tab.
2. Click **Add Simulation**.
3. Enter:
   - **Title** (e.g., “Firewall Configuration Lab 1”).
   - **Optional date**.
   - **Link** or choose from the **Simulation Library**.
4. Click **Save**.

**Using the Simulation Library:**

1. Click **Choose from Simulation Library**.
2. Select a preconfigured simulation.
3. Save.

**Student guidance:**
- Instruct students to **take a screenshot** of their completion screen (especially when they earn 3 stars).
- Have them upload or share that screenshot according to your instructions so you can mark the simulation as pass/fail.

---

### Assignments

![Image](/docs/images/assignments.png)

Assignments typically link out to external tools, documents, or file drop locations.

**To create an assignment:**

1. Open the class workspace → **Assignments** tab.
2. Click **Add Assignment**.
3. Fill in:
   - **Title** (e.g., “Week 3 Packet Tracer Assignment”).
   - **Optional due date** and time.
   - **Link** to the assignment (Google Doc, LMS task, shared folder, etc.).
4. Click **Save**.

Once students start submitting work, you may see **submission count badges** (e.g., a green badge showing how many students turned in the assignment).

**To edit or remove an assignment:**

- Click **Edit** next to the assignment.
- Update the title, due date, or link.
- Save changes.
- Use **Delete** (if available) to remove an outdated or incorrect assignment.

> **Tip:** When changing links, notify students via an announcement so they don’t use an old URL.

---

### Resource Libraries

Resource libraries (Lecture Library, Simulation Library, etc.) let you reuse content across multiple classes.

**Typical workflow:**
1. Admins or senior instructors populate the shared library with standard resources.
2. Instructors pull from this library into their classes (Lectures/Simulations).
3. Updates to library items can be reused in future terms.

Use the libraries whenever possible to avoid rebuilding the same content for each new class.

---

## 5. Assessments & Tests

![Image](/docs/images/Teacher/NewTest.png)

The **Tests** area lets you assign quizzes, unit exams, or final tests and control how students access them.

### Accessing the Tests tab

1. Open your class workspace.
2. Click the **Tests** tab/menu option.

You’ll see tools organized in tabs such as:

- **Test / Quiz** – For MDTS-hosted tests.
- **Link** – For externally hosted tests (e.g., another system or tool).

### Assigning a test from the Test/Quiz tab

1. Go to **Tests → Test / Quiz**.
2. Click **Assign Test** or similar.
3. Choose a test from:
   - Your own test bank.
   - The institutional test library.
4. Set:
   - **Title** (if not already set).
   - **Due date**.
   - **Availability window** (if needed).
   - **Time limit** (if required).
5. Save.

### Using an external test (Link tab)

1. Go to **Tests → Link**.
2. Click **Add Linked Test** (or equivalent).
3. Enter:
   - Title.
   - External URL to the test.
   - Optional due date or instructions.
4. Save.

### Previewing tests

Before you release a test:

1. Click **Preview** next to the test.
2. Scroll through all questions.
3. Confirm that:
   - Points and answers are correct.
   - Instructions are clear.
4. Close the preview and make any necessary edits.

### Attempts and study mode

- Students have **5 test attempts** in graded test mode before lockout.
- Students have **unlimited attempts in Study mode**, which is designed for practice and self-paced review.

### Gradebook connection

- When a student completes a test in **Test mode**, the grade is automatically added to the **Gradebook**.
- Study mode attempts are usually for practice and do not count as graded attempts unless configured otherwise by admins.

![Image](/docs/images/Teacher/TestPreview.png)
---

## 6. Grading & Student Progress

The **Gradebook** and progress tools help you evaluate learning and intervene early when needed.

### Gradebook Overview

- Everything you grade appears in the **Gradebook** section:
  - Tests
  - Assignments
  - Simulations (pass/fail)
- At the top, you may see filters and tools; at the bottom, you see averages.

Features include:
- Inline editing of scores.
- Automatic class averages at the bottom of each column.
- Quick actions for printing, exporting CSVs, and reviewing statistics.
- Direct links to attendance reports to cross-check engagement.

![Image](/docs/images/Teacher/TeacherQuickActions.png)

> **Important:** After entering multiple grades, click **Save Grades** to ensure your changes are stored.

### Working the gradebook (deep dive)

![Image](/docs/images/gradebook.png)

**Columns:**
- Each graded activity (test, assignment, simulation) appears as its own column.
- Totals/averages appear in a footer row.

**Inline editing:**
1. Click directly into a score cell.
2. Type the new score.
3. Click outside the cell to commit the value.
4. Click **Save Grades** when you’re done editing.

**Sorting and filtering:**
- Use any available controls above the table to:
  - Sort by last name or first name.
  - Filter by completion status.
  - Search for a specific student.

**CSV export:**
1. Apply any filters you want (e.g., a single class or subset of students).
2. Click **Export CSV**.
3. Use the downloaded file in Excel, Sheets, or your SIS.

**Printing:**
- Click **Print Gradebook** (where available) for a print-friendly version, useful for meetings or records.

---

### Auto-Grading vs Manual Grading

![Image](/docs/images/Teacher/GradeReport.png)

**Automatically graded:**
- Multiple choice questions.
- True/False questions.
- Objective question types supported by the system.

When students submit:
- The LMS calculates scores automatically.
- In **Study mode**, students usually see feedback immediately.
- In **Test mode**, results may appear immediately or only after you release them, depending on settings.

**Manual grading required for:**
- Essay questions.
- Short answer responses.
- Certain open-ended items.
- Assignments (based on uploaded work or external completion).
- Simulations (usually marked Pass/Fail).

**Manual grading workflow:**

1. From **Gradebook** or the specific **Assignment/Test view**, open the submission.
2. Read the student response or review the attached file/screenshot.
3. Enter the score in the grade field.
4. Add written feedback comments if helpful (e.g., what they did well; what to fix).
5. Click **Save** or **Save Grades**.

> **Simulation tip:** Ask students to send or upload a screenshot of their completed simulation (with 3 stars or equivalent) and then mark it as Pass in the gradebook.

---

### Grade Override & Adjustments

Sometimes you need to adjust grades manually.

**Use overrides for:**
- Extra credit.
- Late work acceptance.
- Correcting errors.
- Grade appeals and academic considerations.

**To override a grade:**

1. Open the **Gradebook**.
2. Click the score cell you want to change.
3. Enter the new score.
4. If available, add a **note** such as “Extra credit for additional project” or “Grade appeal adjustment.”
5. Click **Save Grades**.

These notes create an audit trail for future reference.

---

### Certificates of completion

![Image](/docs/images/certsend.png)

Use certificates when a student meets completion criteria (such as passing and attendance thresholds).

**To send a certificate:**

1. From the class **Gradebook** or **Class roster**, locate the student.
2. Click the **Certificate** icon/button.
3. Confirm the details (course name, student name, completion date).
4. Click **Send**.

The system:
- Emails a PDF certificate to the student.
- Optionally CCs admin (depending on settings).
- Stores a copy in the student’s profile.

If sending fails:
- Try again later.
- If it still fails, contact an admin with the student name and class.

Certificates typically include:
- Student name.
- Course name.
- Completion date.
- Clock hours.
- Your digital signature (if uploaded).
- MD Technical School branding.

---

### Tracking Progress

The platform gives several visual indicators of student progress.

**Student progress indicators:**
- **Green checkmarks** – Completed lectures/tests.
- **Progress bars** – Overall % of class content completed.
- **Warning icons** – Students who are behind schedule or missing key items.

**To review individual student progress:**

1. From the class roster or gradebook, click a student’s name.
2. In the student’s course view, you can see:
   - Which lectures they have opened.
   - Which tests they attempted and how many times.
   - How long they spent on content (if tracked).
   - Which assignments they have submitted or missed.

Use this information to:
- Identify at-risk students early.
- Plan targeted outreach.
- Adjust pacing or remediation plans.

---

## 7. Attendance Tracking

![Image](/docs/images/attendance.png)

Attendance tracking is directly linked to student clock hours and is important for compliance.

### Recording attendance

1. Open the class workspace.
2. Click the **Attendance** tab.
3. Use the date picker to select the session date.
4. For each student:
   - Toggle them **Present** or **Absent**
5. Once you’ve marked the whole class, click **Save Attendance**.

The session is now logged and contributes to their clock hours.

### Viewing attendance history

Below the current date area, you’ll see a table of past sessions.

You can:
- Scroll to see earlier dates.
- Confirm a student’s attendance pattern over time.

### Printing attendance

To generate a paper or PDF record:

1. Click **Print Overall Attendance**.
2. Adjust printer settings and confirm.
3. File or share for audits, accreditation, or meetings.

### Mobile-friendly roll call

The attendance page is designed to work on mobile browsers too:

- Open the LMS from your phone or tablet.
- Navigate to **Attendance**.
- Tap toggles as you call names.
- Save when you’ve finished.

---

## 8. Student Management

Teachers have access to profiles and tools for the students enrolled in their classes.

### Viewing Student Profiles

1. Go to your class workspace.
2. Open the **Roster** (or equivalent).
3. Click a student’s name.

![Image](/docs/images/Teacher/StudentRoster.png)

You’ll see:

- Active and past enrolled classes.
- Current grades in your course.
- Documents and certificates.
- Attendance records.
- Tuition information (view-only).
- Notes from advisors or admins.

---

### Student Actions Available to Teachers

**Reset Password:**
![Image](/docs/images/Admin/Reset%20Password.png)

1. Open the student’s profile.
2. Click **Reset Password**.
3. Confirm the reset.
4. The system emails a temporary password to the student.
5. Remind them to change it after logging in.

**Send Email:**

1. From the profile, click **Contact** or **Send Email**.
2. Choose a template or write your own message.
3. Add any attachments or links needed.
4. Send.

The email is logged in the student’s interaction history for future reference.

**View Transcripts:**

- Use this when you need to understand a student’s academic background.
- In their profile, open **Transcripts** or **Academic History** (if available).
- Review completed courses and grades.

**Track Progress (per student):**

From the profile:
- Check which lectures the student has opened.
- View test scores and dates.
- Confirm which assignments are submitted or missing.
- See attendance history.

---

### Student Notes

Use the notes system to coordinate with other staff.

**To add a note:**

1. In the student profile, find the **Notes** section.
2. Click **Add Note**.
3. Type a clear, factual summary (e.g., “Discussed missing midterm; student plans to submit by Friday”).
4. Save.

Notes automatically include timestamps and are visible to admins and other teachers.

**Best practices:**

- Keep notes professional and objective.
- Avoid speculation; focus on facts and outcomes.
- Add notes after major conversations, interventions, or accommodations.
- Read existing notes before a meeting so you understand student history.

---

## 9. Communicating with Students

Clear communication keeps students on track and reduces confusion.

### Discussion board

![Image](/docs/images/Teacher/DiscussionBoard.png)

Use the discussion board for in-class and asynchronous conversation.

- **To post:**
  1. Go to the class **Discussion** or **Discussion Board**.
  2. Click **New Post** or similar.
  3. Add a subject and message.
  4. Post it.

- **To reply:**
  - Click on a thread.
  - Type your response and submit.

Replies include names and timestamps so you can track participation.

---

### Direct contact

You can message students individually when needed.

- From **Attendance** or **Roster**, find the student.
- Click **Contact** next to their name.
- Compose your message using the formatting tools (bold, bullet points, links).
- Add relevant URLs (e.g., assignment page, resource link).
- Send.

Messages route through the school’s email system to keep communication consistent and trackable.

---

### Announcements page

![Image](/docs/images/Teacher/announcements.png)

Announcements are global messages visible to the whole class.

1. From the top navigation, click **Announcements**.
2. Choose **Create Announcement**.
3. Enter:
   - A clear title/subject.
   - The body text (include due dates, links, instructions).
4. Select which class(es) or audiences should receive it (if options are available).
5. Post.

Announcements appear on student dashboards immediately.

- When the announcement is no longer relevant, you can:
  - Delete it.
  - Or edit and update its content.

---

### Email Best Practices

- **Response Time:** Aim to reply within **24–48 hours**.
- **Professional Tone:** Even in casual classes, maintain professional language and clarity.
- **Clear Subject Lines:** Example: “Week 2 Lab Instructions – Network Security”.
- **Proofread:** Check spelling and grammar; avoid ambiguous phrases.
- **Action Items:** Make expectations explicit (e.g., “Submit by Sunday 11:59 PM”).
- **Use Templates:** Save responses for common questions (late work policy, office hours, etc.) to speed things up.

---

## 10. Calendar & Events

![Image](/docs/images/Teacher/Teacher%20Dashboard.png)

The calendar aggregates:

- Your class meeting times.
- School-wide events you’re invited to.
- Deadlines and major dates.

### Viewing and interpreting the calendar

- On the teacher dashboard, locate the calendar.
- Class sessions appear automatically based on your **Schedule** tab settings.
- Admin-created events (interviews, workshops, orientations) appear if you are tagged/invited.

**Color coding (if enabled):**
- One color for your classes.
- Another for school events.
- Another for special deadlines or assessments.

> **If times look wrong:**  
> Check the class **Schedule** tab and adjust start/end times. Changes will sync to the calendar.

---

## 11. Reports & Downloads

Use **Reports** to generate documents for meetings, records, or admin requests.

### Class-level reports

From the header, choose **Reports**, or open reports from within a specific class:

- **Print Gradebook** – Good for:
  - Parent-teacher conferences.
  - Advisor meetings.
  - Offline review.

- **Export Grades CSV** – Good for:
  - Importing into external SIS systems.
  - Deeper data analysis in Excel/Sheets.

- **Attendance Report** – Shows historical attendance patterns and totals.

- **Class Summary** – Helpful when admins want:
  - Enrollment counts.
  - Average grades.
  - Overall completion rates.

- **Student Progress Report** – Summarizes progress across all course materials for each student.

---

### Individual Student Reports

![Image](/docs/images/Teacher/GradeReport.png)

To generate a report for a single student:

1. Open the student profile from your class roster.
2. Click **Generate Report** or **Grade Report**.
3. Wait for the system to compile the data into a PDF, including:
   - All test scores and grades from your class.
   - Attendance record.
   - Progress on lectures and assignments.
   - Overall course grade and completion percentage.
4. Download the PDF or email it directly to the student (or parent/advisor, if appropriate).

Use these reports for:
- Parent meetings.
- Academic advising.
- Progress check-ins.
- Documentation of accommodations or support plans.

---

## 12. Teacher Utilities

These tools enhance your teaching workflow and help personalize your class.

- **Topic Helper** – AI brainstorming aid.
- **Resource Links** – Centralize important URLs for students.
- **Signature Upload** – Ensure official documents have your signature.
- **Content Simplification Tool** – Adjust reading level of complex material.

---

### Topic Helper (AI Teaching Assistant)

Use Topic Helper when planning lessons or support content.

1. From the dashboard, click **Topic Helper**.
2. Enter the topic (e.g., “Subnets and CIDR”, “Respiratory System Anatomy”).
3. Choose what you want:
   - Teaching analogies.
   - Lesson outline.
   - Key concept summaries.
   - Discussion questions.
   - Real-world examples.
4. Review the suggestions and copy/paste the parts you like into:
   - Lecture notes.
   - Assignments.
   - Discussion prompts.

**Best use cases:**
- Breaking down tough concepts.
- Generating starter content quickly.
- Adapting explanations for different levels of students.

---


### Teacher Links

![Image](/docs/images/teacherlinks.png)

Teacher Links make it easy for students to find your key resources.

1. Go to **Account → Teacher Links**.
2. Click **Add Link**.
3. Enter:
   - A descriptive **name** (e.g., “Wednesday Office Hours Zoom”).
   - The **URL**.
4. Optionally, upload an icon or image to make it stand out.
5. Save.

Common examples:
- Virtual office hours booking page.
- Shared Google Drive or OneDrive folder.
- Tutorial video playlist.
- External LMS or practice system.
- Professional portfolio or LinkedIn (if relevant).

---

## 13. Account Settings

From the **Account** page you can manage your instructor profile and security settings.

### Update profile details

1. Click **Account** in the top navigation.
2. In the **Profile** section:
   - Update your display name and signature name.
   - Upload/replace your profile image.
   - Upload/replace your digital signature.
3. In the **Teacher Links** section:
   - Add or edit links students should see.
4. Review your email and contact details.
5. Click **Save** to apply changes.

![Image](/docs/images/Teacher/account.png)

---

### Change your password

![Image](/docs/images/Passwordchang.png)

1. From the **Account** view, open the **Password** section.
2. Enter your current password.
3. Enter a new secure password (use a mix of letters, numbers, and symbols).
4. Confirm the new password.
5. Click **Save**.

**Notes:**
- If you’re forced to change your password at login, you must complete that process before accessing the rest of the LMS.
- If you forget your password:
  - Use the **Forgot Password** link on the login page.
  - Check your email for the reset link.
  - If you don’t receive it, contact an admin.

---

## 14. Best Practices & Tips

This section offers practical strategies for smooth teaching in the LMS.

### Course Organization

![Image](/docs/images/Teacher/ClassSummary.png)

- Organize content by **week**, **unit**, or **module**.
- Use descriptive titles (e.g., “Week 3: Cardiovascular System” instead of “Lecture 3”).
- Upload the **syllabus** first so students know what to expect.
- Review and update course materials at least **once per term**.
- Use consistent naming across all your classes.

### Student Engagement

![Image](/docs/images/Teacher/DiscussionBoard.png)

- Post discussion prompts weekly to keep conversations active.
- Send a weekly announcement summarizing:
  - What was covered.
  - What’s due next.
  - Any changes.
- Provide **specific** feedback, not just grades.
- Clearly state expectations for each assignment and test.
- Respond to emails in **24–48 hours** whenever possible.
- Hold regular office hours and remind students about them.

### Grading Efficiency

![Image](/docs/images/Teacher/GradeBook.png)

- Use auto-graded question types (MC, T/F) for quick checks.
- Build rubrics for essays and projects so grading is consistent and faster.
- Aim to return graded work within **one week**.
- Create a bank of common comments you can reuse.
- Grade in batches (all submissions for Assignment 1, then Assignment 2, etc.).

### Assessment Design

![Image](/docs/images/Teacher/TestPreview.png)
- Ensure tests truly measure your stated learning objectives.
- Include a mix of easy, medium, and challenging questions.
- Provide **study mode** practice tests before high-stakes exams.
- Make instructions clear: attempt limits, time limits, and allowed resources.
- Set reasonable time limits based on question count and complexity.
- Use randomization features (where available) to reduce cheating.

### Content Quality

- Mix formats: videos, text, simulations, diagrams, etc.
- Use **headings and bullet points** to keep content readable.
- Periodically click your own links to ensure they still work.
- Compress large files or split content to improve loading speed.
- Add captions to videos when possible.
- Check how key pages look on mobile devices.

### Time Management

- Use consistent due dates (e.g., Sundays at 11:59 PM).
- Pre-schedule content releases to avoid last-minute uploads.
- Batch similar tasks (e.g., grade all quizzes in one sitting).
- Use personal reminders or calendar events for grading deadlines.
- Use content “drip” schedules if supported to stagger workload.

### Data Privacy & Security

- Never post student grades or personal information in public spaces.
- Use a strong, unique password for the LMS.
- Log out on shared or public computers.
- Follow FERPA and institutional guidelines when sharing records.
- Use BCC when emailing groups of students.
- Verify identity before sharing sensitive info like grades.

### Student Support Strategies

- Monitor attendance and progress reports for early warning signs.
- Reach out to absent or struggling students proactively.
- Share tutoring resources, recorded sessions, and study guides.
- Honor documented accommodations and coordinate with admin when needed.
- Recognize student progress and success (with their permission).
- Document serious concerns in student notes and loop in advisors/admins when appropriate.

---

## 15. Troubleshooting & FAQ

**I forgot my password.**  
![Image](/docs/images/Teacher/ForgotPassword.png)
Use the **Forgot Password** link on the login screen. You’ll receive an email to reset it. If no email arrives within 5 minutes, check spam/junk folders and then contact an administrator.

---

**A student cannot see an assignment.**  
1. Verify the assignment is listed under **Assignments** for that class.
2. Check that the assignment URL is correct and still active.
3. Ensure the assignment is **published** or visible (not draft/hidden).
4. If it came from a library, verify the resource still exists.
5. Re-add or edit the entry if necessary; submission history should remain.

---

**My grade changes did not save.**  
1. Make sure you clicked outside the cell after typing each grade.
2. Confirm you clicked **Save Grades** before leaving the page.
3. If you navigate away without saving, the LMS will revert to the previous values.

---

**A test did not appear for students.**  
1. Confirm that the test is attached to the correct class in **Tests**.
2. Ensure the test has a title and (if required) a time limit.
3. Check the **availability dates** and status.
4. Preview the test to confirm it has questions.
5. If everything looks correct, ask an admin to verify system settings.

---

**I need to send login details again.**  
Admins can resend credentials from the **Teacher List** or **User Management** area. If a colleague is locked out or a student never received credentials, contact the admin team with their full name and email.

---

**Something isn’t working as expected.**  
1. Take a screenshot of the problem (if possible).
2. Note the class name, what you were trying to do, and any error messages.
3. Contact an MD Tech admin or submit a support ticket via **Account → Support**.
4. Include the screenshot and details to speed up troubleshooting.

---

**The calendar shows the wrong time.**  
1. Open the class **Schedule** tab.
2. Confirm the start and end times are correct.
3. Adjust if needed and save.
4. If the system-wide time zone seems off, report it to admin.

---

**How do I see student attendance trends?**  
Use the **Attendance Report** in **Reports** or the **Attendance** tab:

- Look for repeated absences or patterns.
- Combine this with gradebook trends to identify at-risk students.

---

**Can I reuse tests from previous classes?**  
Yes. Use the **Test Library**:

1. Go to **Tests** for your current class.
2. Select a test from your library or institution test banks.
3. Attach and adjust due dates for the new term.

---

**How do I handle academic integrity issues?**  
1. Document the concern in the student’s **Notes**.
2. Check test logs for:
   - Unusual attempt patterns.
   - Very short completion times with high scores.
3. Gather any evidence and contact admin.
4. Follow MDTS and institutional policies for academic integrity.

---

**Student can't log into the class.**  
1. Confirm the student is on your class **Roster**.
2. Check with admin that their status is **Accepted**, not **Pending**.
3. Have the student:
   - Confirm their username/email.
   - Reset their password via **Forgot Password**.
   - Clear browser cache or try another browser.
4. If the problem persists, send details to admin.

---

**File upload failed.**  
1. Check if the file size is under the allowed limit (commonly 10MB).
2. Confirm the file type is supported (PDF, PPTX, JPG, PNG, MP4, etc.).
3. Try compressing the file or splitting it into parts.
4. Suggest the student use a different browser if errors continue.

---

**Grades aren't showing for students.**  
1. Confirm you clicked **Save Grades** after entering scores.
2. Check whether the test is set to **Test Mode** and not just **Study Mode**.
3. Ensure all essay/short answer questions have been manually graded.
4. If visibility settings exist (e.g., “Show grades to students”), confirm they are enabled.

---

## 16. Change Log

- **December 2024** – Added Student Management section (section 8), enhanced Grading & Student Progress with manual grading workflows and progress tracking, expanded Teacher Utilities with AI tools (Topic Helper, Content Simplification), comprehensive Best Practices section, expanded troubleshooting FAQ.
- **January 2025** – Added inline help icons and updated quick actions.
- **December 2024** – Introduced AI test generator and enhanced gradebook exports.
- **October 2024** – Launched resource libraries for lectures, simulations, and assignments.

---

Need more help? Reach out to the MDTS admin team or submit a ticket through the **Account → Support** option. We're here to help you teach with confidence.
