#!/bin/bash

# Performance monitoring script for the LMS

echo "=== Server Performance Check ==="
echo ""

# Check Node.js process
echo "1. Node.js Process:"
ps aux | grep "node app.js" | grep -v grep | awk '{print "   CPU: " $3 "% | Memory: " $4 "% | " $11 " " $12}'
echo ""

# Check for slow requests in the last 50 lines
echo "2. Recent Slow Requests (>500ms):"
tail -50 /tmp/server.log | grep "\[SLOW\]" | tail -10
if [ $? -ne 0 ]; then
  echo "   No slow requests detected"
fi
echo ""

# Check database connections
echo "3. Database Connection Test:"
mysql -h 66.45.23.10 -u mdtsapps_mdviewer -pTheMadden04! mdtsapps_myclass -e "SELECT COUNT(*) as active_connections FROM information_schema.processlist WHERE db='mdtsapps_myclass';" 2>/dev/null || echo "   Unable to check (this is ok)"
echo ""

# Check disk usage
echo "4. Uploads Directory Size:"
du -sh uploads/ 2>/dev/null || echo "   No uploads directory"
echo ""

echo "5. Recent Server Errors:"
tail -50 /tmp/server.log | grep -i "error" | grep -v "ensureSyllabusColumns" | tail -5
if [ $? -ne 0 ]; then
  echo "   No recent errors"
fi
echo ""

echo "=== Tips for Better Performance ==="
echo "   - Watch for [SLOW] requests in logs: tail -f /tmp/server.log | grep SLOW"
echo "   - Check browser Network tab for slow loading resources"
echo "   - Clear browser cache if pages seem slow"
echo "   - Restart server if memory usage is high: npm run restart"
