# Signature PDF Generation Fix

## Problem
When viewing partially signed or completed documents, signatures were not appearing on the PDF. The download also showed the original PDF without signatures.

## Root Cause
The `generateSignedPDF` function in `utils/documentSigning.js` was only returning the original PDF buffer without overlaying the signatures and field responses.

## Solution Implemented

### 1. Updated `generateSignedPDF` Function
Modified the function to use `pdf-lib` to:
- Load the original PDF
- Get all field responses from the database
- Convert canvas-based percentage positions to PDF coordinates
- Overlay signature images at the correct positions
- Add text field responses with proper formatting
- Save the modified PDF with all signatures and data

### 2. Added New Route for Signed PDF Preview
Created `/document-signing/pdf-signed/:documentId` route that:
- Checks user access (admin, party, or student)
- Generates PDF with signatures overlaid
- Serves it for inline viewing (not download)

### 3. Updated View Template
Modified `views/signature_document_view.ejs` to:
- Use the new signed PDF route instead of the original file
- Display signatures in the embedded PDF viewer

## Technical Details

### Coordinate Conversion
- **Canvas coordinates**: Top-left origin (0,0), percentage-based
- **PDF coordinates**: Bottom-left origin (0,0), pixel-based
- **Conversion formula**: 
  ```javascript
  x = (field.x_position / 100) * width
  y = height - ((field.y_position / 100) * height) - ((field.height / 100) * height)
  ```

### Signature Image Handling
- Signatures are stored as base64-encoded data URLs
- Extracted and decoded for PDF embedding
- Supports both PNG and JPEG formats
- Fallback to text label if image embedding fails

### Field Types
- **Signature fields**: Embedded as images on the PDF
- **Text fields**: Drawn with white background, border, and text content
- **Other fields**: Rendered as text with appropriate formatting

## Routes

| Route | Purpose | Access |
|-------|---------|--------|
| `/document-signing/pdf/:documentId` | Original PDF for editing | Admin only |
| `/document-signing/pdf-signed/:documentId` | PDF with signatures | Auth users with access |
| `/document-signing/download/:documentId` | Download signed PDF | Auth users with access |

## Files Modified

1. **utils/documentSigning.js**
   - Implemented full `generateSignedPDF` function with pdf-lib
   - Handles coordinate conversion
   - Embeds signature images and text fields

2. **routes/documentSigning.js**
   - Added `/pdf-signed/:documentId` route
   - Updated comments on existing `/pdf/:documentId` route

3. **views/signature_document_view.ejs**
   - Changed embed src from direct file to signed PDF route

## Testing

To verify the fix works:

1. **Create a document** with signature fields through the admin panel
2. **Assign parties** (student and staff)
3. **Sign the document** as one party
4. **View the partially signed document**:
   - Go to `/document-signing/view/:documentId`
   - You should see the signature on the PDF
5. **Download the document**:
   - Click "Download PDF" button
   - Open the downloaded PDF
   - Signatures should be visible
6. **Complete signing** with all parties
7. **Verify completed document** shows all signatures

## Dependencies

- **pdf-lib**: Used for PDF manipulation and signature overlay
- Installed via: `npm install pdf-lib`

## Performance Considerations

- PDF generation happens on-demand
- No caching implemented (generates fresh PDF each time)
- For production, consider:
  - Caching generated PDFs until signatures change
  - Background job to pre-generate signed PDFs
  - CDN for serving completed documents

## Future Enhancements

Potential improvements:
- Add signature timestamps on the PDF
- Include audit trail on final page
- Add certificate of completion watermark
- Support for initial fields (pre-filled by admin)
- Digital signature validation
