const db = require('./db');

const TEST_TABLE = 'LMSTest5';


async function getQuestionsByTest(testName) {
  const [rows] = await db.query(`SELECT * FROM ${TEST_TABLE} WHERE Test = ? ORDER BY id ASC`, testName);
  
  return rows.map((r) => {
    const rawOptions = [r.OptionA, r.OptionB, r.OptionC, r.OptionD, r.OptionE, r.OptionF, r.OptionG];
    const options = rawOptions.filter(v => v !== undefined && v !== null).map(v => String(v));
    const ansRaw = r.Answer !== undefined && r.Answer !== null ? String(r.Answer).trim() : '';

    let answerIndex = -1;

    // 1) Check if answer is a letter (A, B, C, D, E, F, G)
    const letterMatch = ansRaw.toUpperCase().match(/^([A-G])$/);
    if (letterMatch) {
      const letterIndex = letterMatch[1].charCodeAt(0) - 'A'.charCodeAt(0);
      if (letterIndex >= 0 && letterIndex < options.length) {
        answerIndex = letterIndex;
      }
    }

    // 2) If not a letter, try matching by value (string)
    if (answerIndex < 0) {
      answerIndex = options.findIndex(opt => String(opt).trim().toLowerCase() === ansRaw.toLowerCase());
    }

    // 3) If still not found, allow numeric index (supports 0-based and 1-based)
    if (answerIndex < 0) {
      const n = parseInt(ansRaw, 10);
      if (!Number.isNaN(n)) {
        if (n >= 1 && n <= options.length) answerIndex = n - 1;
        else if (n >= 0 && n < options.length) answerIndex = n;
      }
    }

    const answerText = answerIndex >= 0 ? options[answerIndex] : ansRaw;
    return {
      question: r.Question,
      answer: answerIndex,
      answerText,
      explanation: r.Explanation,
      picture: r.Picture,
      options,
      test: r.Test,
      contentType: r['Content Type'],
      title: r.Title,
      itemType: r['Item Type'],
      path: r.Path
    };
  });
}

async function replaceTestQuestions(testName, questions) {
     console.log("inert 2");
  await db.query(`DELETE FROM ${TEST_TABLE} WHERE Test = ?`, [testName]);
  for (const q of questions) {
    const opts = q.options || [];
    const correctAns =
      typeof q.answer === 'number'
        ? opts[q.answer] || q.answerText || ''
        : q.answer || q.answerText || '';
    await db.query(
      `INSERT INTO ${TEST_TABLE} (Question, Answer, Explanation, Picture, OptionA, OptionB, OptionC, OptionD, OptionE, OptionF, OptionG, Test, \`Content Type\`, Title, \`Item Type\`, Path) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`,      [
        q.question || '',
        correctAns,
        q.explanation || '',
        q.picture || '',
        opts[0] || '',
        opts[1] || '',
        opts[2] || '',
        opts[3] || '',
        opts[4] || '',
        opts[5] || '',
        opts[6] || '',
        q.title,
        q.contentType || 'multiple-choice',
        q.title || '',
        q.itemType || 'Question',
        q.path || ''
      ]
    );
  }
}

async function insertQuestions(questions) {
    console.log("inert 1");
  for (const q of questions) {
    const opts = q.options || [];
    const correctAns =
      typeof q.answer === 'number'
        ? opts[q.answer] || q.answerText || ''
        : q.answer || q.answerText || '';
    await db.query(
     `INSERT INTO ${TEST_TABLE} (Question, Answer, Explanation, Picture, OptionA, OptionB, OptionC, OptionD, OptionE, OptionF, OptionG, Test, \`Content Type\`, Title, \`Item Type\`, Path) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`,      [
        q.question || '',
        correctAns,
        q.explanation || '',
        q.picture || '',
        opts[0] || '',
        opts[1] || '',
        opts[2] || '',
        opts[3] || '',
        opts[4] || '',
        opts[5] || '',
        opts[6] || '',
        q.title || '',
        q.contentType || 'multiple-choice',
        q.title || '',
        q.itemType || 'Question',
        q.path || ''
      ]
    );
  }
}

async function updateQuestionMediaByText(testName, questionText, mediaUrl, isVideo = false) {
  const col = isVideo ? 'Path' : 'Picture';
  await db.query(`UPDATE ${TEST_TABLE} SET ${col}=? WHERE Test=? AND Question=?`, [mediaUrl, testName, questionText]);
  return true;
}

async function deleteTest(testName) {
  await db.query(`DELETE FROM ${TEST_TABLE} WHERE Test = ?`, [testName]);
}

async function renameTest(oldName, newName) {
  await db.query(`UPDATE ${TEST_TABLE} SET Test = ?, Title = ? WHERE Test = ?`, [newName, newName, oldName]);
}

module.exports = { getQuestionsByTest, replaceTestQuestions, insertQuestions, updateQuestionMediaByText, deleteTest, renameTest };
