# MDTS Student Guide

Welcome to MD Technical School’s Learning Management System (LMS). This guide explains how you can manage your classes, stay organized, and access resources.

---

## Table of Contents

1. [Getting Started](#1-getting-started)
2. [Dashboard Tour](#2-dashboard-tour)
3. [My Classes](#3-my-classes)
4. [Class Detail Page](#4-class-detail-page)
5. [Assignments & Tests](#5-assignments--tests)
6. [Progress & Grades](#6-progress--grades)
7. [Attendance & Certificates](#7-attendance--certificates)
8. [Messages & Announcements](#8-messages--announcements)
9. [Account & Settings](#9-account--settings)
10. [Support & Troubleshooting](#10-support--troubleshooting)

---

## 1. Getting Started

- Check your email for the login link and temporary password.
- Navigate to the LMS login page and sign in.
- You will be asked to create a new password on your first login.

> [Add screenshot: Login screen]

---

## 2. Dashboard Tour

Your student dashboard gives a quick overview of your status:

- **Quick Links** – jump to My Classes, Announcements, or your report.
- **Upcoming Classes** – see what’s scheduled this week.
- **Announcements** – stay informed with school updates.
  - Click the announcement title to read the full message.
- **To-Do Items** – if your program uses checklists, they appear here.

> [Add screenshot: Student dashboard]

---

## 3. My Classes

- Access all your enrolled classes from the My Classes page.
- Each class card shows the class name, meeting schedule, and teacher.
- Click a class name to open the detailed class page.

> [Add screenshot: My Classes list]

Tips:
- Use the schedule information to plan your week.
- If a class is missing, contact your advisor or admin team.

---

## 4. Class Detail Page

The class detail page is your main hub for coursework:

- **Overview** – class description, start/end dates, teacher notes.
- **Materials** – lecture slides, videos, simulations, assignments.
- **Checklist** – tasks your teacher wants you to complete.
- **Discussion Board** – participate in class discussions or ask questions.
- **Gradebook** – see your grades for tests, assignments, and labs.
- **Attendance** – review attendance history (if enabled).

> [Add screenshot: Class detail with tabs]

How to use:
1. Start with the Overview to understand expectations.
2. Download lecture materials before class if you want to study ahead.
3. Check the Checklist for prep tasks.
4. Add reminders for due dates based on assignment/test sections.

---

## 5. Assignments & Tests

### Assignments
- Go to the Assignments section within a class.
- Each entry shows the title, link, due date, and submission count.
- Submit work as directed (pay attention to the submission instructions).

> [Add screenshot: Assignments list]

### Tests / Quizzes
- Access tests from the Tests tab in your class.
- Click “Take Test” or “Preview” (if allowed) to see the layout.
- Tests may have a time limit—plan to complete them in one sitting.
- When you submit, watch for confirmation that your responses were saved.

> [Add screenshot: Test list with due dates]

Tips:
- Review tests from the **Test Result** page once your teacher releases grades.
- Some instructors provide practice simulations; use them to prepare.

---

## 6. Progress & Grades

- **Gradebook** tab shows your scores for tests, assignments, and labs.
- Class averages appear at the bottom for comparison.
- Download or print the gradebook if you need a copy (button provided by your teacher).

> [Add screenshot: Student gradebook]

Extra features:
- Some classes include progress charts or badges—check with your teacher if you don’t see them.
- Use the gradebook to identify areas that need extra study.

---

## 7. Attendance & Certificates

- **Attendance** tab shows dates you were marked present.
- Spot any incorrect entries? Contact your teacher so they can update the record.

Certificates:
- When you finish a class, your teacher may email you a certificate of completion.
- Certificates can usually be accessed via the **Certificates** section in your student profile.
- Download or print your certificates for your records.

> [Add screenshot: Attendance table / Certificate list]

---

## 8. Messages & Announcements

- **Announcements** page displays school-wide news and class updates.
- Check it regularly to stay current on schedule changes or events.
- If your classroom discussion board is enabled, you can post questions or respond to classmates.

> [Add screenshot: Student announcements page]

Email tips:
- Make sure your profile email is current so you receive all notifications.
- Some messages may come from `noreply@mdts-apps.com`; add it to your safe sender list.

---

## 9. Account & Settings

- Go to **Account** in the top navigation to manage your profile.
- Update contact information, emergency contacts, and address details if allowed.
- Change your password:
  1. Enter current password.
  2. Enter new password.
  3. Confirm the new password and save.
- Upload a profile photo if requested by your teacher.

> [Add screenshot: Account settings]

Security tips:
- Use a strong, unique password.
- Always log out of public or shared computers.

---

## 10. Support & Troubleshooting

Common scenarios:
- **Missing class** – confirm with your teacher or admin that you’re enrolled.
- **Can’t open a file** – check that you have the right software (PDF reader, PowerPoint) or request an alternate format.
- **Test didn’t submit** – refresh the Test Result page; if it’s missing, contact your teacher immediately with details.
- **Certificate not received** – check the Certificates section or your email; if missing, ask your teacher/admin.

If you still need help:
- Contact your teacher directly (look for contact info on the class page).
- Reach out to the MDTS admin team—include the class name, issue, and any error messages.
- For technical issues (e.g., red error banners), take a screenshot and send it to support.

> [Add screenshot: Error banner example]

---

Keep this manual handy and check for updates. We’re excited to support your learning at MD Technical School!
