# MDTS Admin Operations Manual

This playbook explains every administrative workflow in the MD Technical School LMS and gives you **step-by-step instructions** for each major task.

**Last Updated:** December 2024 | **Version:** 2.0

---

## Table of Contents

1. [Access & Security](#1-access--security)
2. [Admin Dashboard Overview](#2-admin-dashboard-overview)
3. [Managing Users](#3-managing-users)
4. [Pre-Registrations & Enrollment Pipeline](#4-pre-registrations--enrollment-pipeline)
5. [Class Management](#5-class-management)
6. [Teacher Onboarding & Support](#6-teacher-onboarding--support)
7. [Student Documents & Certificates](#7-student-documents--certificates)
8. [Financial Management & Tuition](#8-financial-management--tuition)
9. [Grades & Historical Records](#9-grades--historical-records)
10. [Alumni Management](#10-alumni-management)
11. [Marketing, Events & Outreach](#11-marketing-events--outreach)
12. [Calendar & Scheduling](#12-calendar--scheduling)
13. [Reports & Analytics](#13-reports--analytics)
14. [Testing Library & Assessments](#14-testing-library--assessments)
15. [Messaging & Announcements](#15-messaging--announcements)
16. [Settings & Configuration](#16-settings--configuration)
17. [Advanced Features & Tools](#17-advanced-features--tools)
18. [Data Exports & Compliance](#18-data-exports--compliance)
19. [Troubleshooting & Support](#19-troubleshooting--support)
20. [Change Log](#20-change-log)

---

## 1. Access & Security

Admin accounts are powerful and must be handled securely.

- Admin accounts are created only by MD Tech leadership.
- Always use strong, unique passwords (and do not reuse them across systems).
- Sessions automatically time out after inactivity to protect data.
- Multi-factor authentication (MFA) is recommended where available—coordinate with IT.

![Account page – Login](/docs/images/Login.png)

### Logging in as an Admin

1. Open the MDTS LMS login page.
2. Enter your **admin username** and **password**.
3. Click **Log In**.
4. If prompted to change your password, complete the change before accessing other pages.

### Changing your password (while logged in)

1. Click **Account** in the header.
2. Scroll to or open the **Change Password** section.
3. Enter your **current password**.
4. Enter and confirm a **new secure password**.
5. Click **Save**.

![Account page – Login](/docs/images/PasswordChange.png)

### Resetting your password (if you forgot it)

1. Go to the login page.
2. Click **Forgot Password**.
3. Enter your email or username.
4. Check your email for a reset link (valid only for a limited time).
5. Click the link and follow prompts to set a new password.

> **Tip:** If you don’t receive a reset email after a few minutes, check spam/junk folders, then contact another admin or IT.

---

## 2. Admin Dashboard Overview

The admin dashboard gives you a **single view of the entire school’s activity**.

![Account page – Login](/docs/images/admindash.png)

### Understanding the Dashboard

- **Hero Stats**
  - Show totals like:
    - Number of classes
    - Active students
    - Recent pre-registrations
  - **Click any stat** to jump to the underlying list or report.

- **Quick Actions**
  - Shortcuts grouped by:
    - **Students** – pre-registrations, pending, accepted, denied.
    - **Classes** – class list, create class, teacher assignment, rosters.
    - **Outreach/Marketing** – events, leads, drip campaigns, partners.
    - **Reports** – analytics and audit tools.
    - **Other utilities** – branding, dropdowns, admin accounts, test libraries.
  - Hover the `?` icon on any button to see:
    - What the action does.
    - When to use it.
    - Who should use it (admin vs advisor vs marketing).

- **Calendar**
  - Shows administrative events.
  - Filters for Events, Interviews, Classes, Tests, Assignments, Custom.
  - Use checkboxes to toggle layers and reduce clutter.

- **My Charts**
  - Displays up to eight **pinned charts** from the Report Charts builder.
  - Use move/remove buttons on each card to reorder or remove.

---

### This Week's Highlights & Next Week Highlights

These sections help coordinate the admin team.

**This Week's Highlights**
- Shows key items happening **this week**.
- Good for:
  - Deadlines (enrollment, documentation, tuition).
  - Interviews, orientations, and open houses.
  - System maintenance windows.
  - Upcoming staff meetings.

**Next Week Highlights**
- Use to **plan ahead**.
- Items you add here will automatically roll into “This Week” when dates align.
- Good for:
  - Major events next week.
  - Multi-day activities and special programs.
  - Communication prep for teachers/students.

#### Updating Highlights

1. On the admin dashboard, locate **This Week's Highlights** and **Next Week Highlights**.
2. Click the **edit (pencil)** icon.
3. Enter or update the text (you can use simple markdown formatting if enabled).
4. Click **Save**.
5. All admins will see the updated highlights immediately.

**Best Practices:**
- Update both highlight sections every **Monday morning**.
- Include dates, times, and a contact person for each item.
- Keep bullets short and actionable.
- Mirror critical items as calendar events for long-term tracking.

---

### Using Quick Actions Effectively

1. Start your shift by opening the **Admin Dashboard**.
2. Scan hero stats, highlights, and the calendar for today’s priorities.
3. Hover over the `?` icon on Quick Actions to see descriptions.
4. Click the button that matches your task:
   - Enrolling new students? → **Students → Pre-Registrations / Pending**.
   - Checking classes? → **Classes → All Classes**.
   - Planning outreach? → **Outreach / Events**.
5. After completing the workflow, use:
   - **Breadcrumbs** or header navigation to go elsewhere.
   - Or the browser **Back** button to return to the dashboard.

> **Tip:** Train new admins to always check the dashboard first before diving into tasks.

---

## 3. Managing Users

Admin users manage **students, teachers, admins, alumni, and career services**.

---

### Students

Students move through several stages:

- **Pre-Registered Users** – filled out interest forms; not yet full students.
- **Pending Students** – conversion initiated; under review.
- **Accepted Students** – actively enrolled.
- **Denied Students** – application closed (but record kept for compliance).

![Account page – Login](/docs/images/pendingstudent.png)

#### Working with Student Lists

1. Open the relevant queue from **Quick Actions** or **Students** menu:
   - Pre-Registered
   - Pending
   - Accepted
   - Denied
2. Use filters to narrow results:
   - Name, email, program, status, date, etc.
3. Click a student record to open their **detailed profile**.

#### In the Student Profile

Inside the profile, you can:

- Review **contact information**.
- Check **documents**, **applications**, **attendance**, **grades**.
- Change **status** (Pending → Accepted/Denied).
- Upload new documents.
- Assign mentors/counselors.
- Add **notes** and interaction logs.
- Reset passwords and send credential emails.

**Changing Student Status (e.g., Pending → Accepted):**

1. From the profile, locate the **Status** field or controls.
2. Choose the new status (e.g., Accepted).
3. Confirm the action.
4. If configured, the system:
   - Logs who changed the status and when.
   - Sends any associated email templates (e.g., acceptance notice).

> **Tip:** Always add a note when you change a student’s status (e.g., “Approved after receiving transcript and payment”).

---

### Teachers

Use teacher tools to onboard, reset, and manage instructors.

![Account page – Login](/docs/images/teacherlist.png)

#### Viewing and Managing the Teacher List

1. Go to **Teachers → Teacher List** (or via Quick Actions).
2. Filter by:
   - Active / inactive
   - Name or email
3. For any teacher:
   - Click their name to open their profile.
   - Use actions like **Resend Credentials**, **Deactivate**, **View Classes**.

**Resending Teacher Login Credentials**

1. On the Teacher List, find the teacher.
2. Click **Resend** (or similar).
3. Confirm that you want to regenerate credentials.
4. The teacher receives a new welcome email with login details.

**Deactivating a Teacher**

1. From the Teacher List or profile, find the **Active/Inactive** toggle.
2. Set to **Inactive**.
3. Save.

> Historical data (classes, grades) remain; the teacher simply can’t log in.

#### Creating a New Teacher Account

1. Navigate to **Create Teacher** (via Quick Actions or Teachers menu).
2. Fill required fields:
   - Name
   - Username
   - Email
3. Optional:
   - Profile photo
   - Digital signature image
   - Teacher Links
4. Toggle **Send Welcome Email** if you want them to receive credentials automatically.
5. Click **Create Teacher**.

---

### Admins

Admin management is under **Settings → Admins** or **Other → Admins**.

- **Add Admin:**
  1. Click **Add Admin**.
  2. Enter name, email, username, role.
  3. Save and (optionally) send credentials.
- **Reset Admin Password:**
  1. From the Admin list, click **Reset Password**.
  2. Confirm; the system emails a temporary password.
- **Deactivate Admin:**
  1. Toggle their status to **Inactive**.
  2. Save.

> Keep admin access limited to people who truly need it (principle of least privilege).

---

### Alumni

The **Alumni** area lets you manage former students after graduation.

**Accessing Alumni:**

1. Go to **Students → Alumni**.
2. Filter by:
   - Graduation year
   - Program
   - Placement status

**Alumni Profile View:**

You can see:
- Full academic history and transcripts.
- Career placement info.
- Current contact details.
- All historical grades and certifications.
- All stored documentation.

**Alumni Management Actions:**

- **Re-enroll Alumni**
  1. Open an alumni profile.
  2. Click **Re-enroll**.
  3. Select a new program or course.
  4. Confirm; they move back into active student status.

- **Update Employment Status**
  1. Open the alumni profile.
  2. Go to the **Career/Placement** section.
  3. Update status (e.g., Searching, Interviewing, Placed).
  4. Save.

- **Send Alumni Communications**
  - Use alumni-specific templates for:
    - Surveys
    - Job updates
    - Events and reunions

- **Export Alumni Reports**
  - From Alumni list, use **Export** to generate lists for accreditation, marketing, or reporting.

---

### Career Services

Career Services provides a focused view on job placement.

**Career Services Dashboard:**

1. Navigate to **Students → Career Services**.
2. See all students in career support:
   - Their advisor
   - Job search status
   - Recent interactions

**Career Services Profile Data:**

For each student you can track:
- Resume versions.
- Job applications (company, position, date).
- Interviews (date, type, outcome).
- Assigned career advisor.
- Placement status (Searching, Interviewing, Placed).
- Employment verification uploads.

**Assigning a Career Advisor:**

1. Open student profile.
2. Go to career/counselor section.
3. Select advisor from dropdown.
4. Save.

**Tracking Job Placement:**

1. Open the student’s career services profile.
2. For each application:
   - Add company, position, and date.
3. After interviews:
   - Update status (e.g., Interviewing).
4. When student is hired:
   - Mark **Placed**.
   - Upload offer letter or verification.
   - (Optional) Record starting salary for metrics.

**Career Services Reports:**

Use career reporting to track:
- Placement rate by program.
- Time from graduation to placement.
- Employer partners.
- Advisor caseloads.
- Employment statistics for accreditation.

---

## 4. Pre-Registrations & Enrollment Pipeline

This section covers the path from **lead** → **pre-registrant** → **pending student** → **accepted/denied**.

![Account page – Login](/docs/images/prereg.png)

### Managing Pre-Registrations

1. Open **Pre-Registrations** from the dashboard or Students menu.
2. Use filters for campaign, status, or date range.
3. Click a record to open details:
   - Contact info
   - Course interest
   - Notes (initial notes from web form, if any)

**Actions for each pre-registrant:**

- **Log communications:**
  - Add call/email notes.
  - Record outcomes and next steps (e.g., “Requested more info on DevOps program”).

- **Schedule interviews:**
  1. Click **Schedule Interview**.
  2. Pick date, time, and interviewer.
  3. Attach location/zoom link.
  4. Save (applicant and assigned staff get notified).

- **Convert to Student:**
  1. When ready, click **Convert to Student**.
  2. Review pre-filled fields (name, email, program interest).
  3. Fill any missing mandatory fields.
  4. Click **Create Student**.
  5. The new student appears under **Pending Students** with login credentials (if configured).

---

### Managing Pending Students

Once converted, students move into **Pending**.

In the Pending queue, you can:

- Track checklists (transcripts, photo ID, payment confirmations).
- Update progress statuses like:
  - Docs Received
  - Awaiting Payment
  - Interview Completed
- Send onboarding emails or additional documentation requests.
- Schedule further interviews or meetings.

**Approving or Denying Students:**

1. Open the pending student profile.
2. Confirm all conditions are met (documents, interviews, tuition plan).
3. Change status to **Accepted** or **Denied**.
4. Add a note explaining the reason.
5. If configured, an email is sent with the decision.

> Use **Reopen** if a denied student reapplies or corrects issues.

---

## 5. Class Management

Class Management allows admins to create, audit, and support all classes.

![Account page – Login](/docs/images/classover.png)

### Working with All Classes

1. Go to **Classes → All Classes**.
2. Filter by:
   - Class name
   - Teacher
   - Cohort
   - Status (active, archived)
3. Each row shows:
   - Enrollment count
   - Start date
   - Teacher name

**From here you can:**

- Click a class name to open details.
- Use quick action buttons to:
  - Edit class info.
  - Duplicate classes.
  - Archive classes.

---

### Creating a New Class

1. Click **Create Class** from Quick Actions or Class menu.
2. Complete **Basic Info**:
   - Class name.
   - Short name (for dashboards).
   - Cohort / school year.
3. Assign **Teacher**:
   - Choose from active teacher list.
4. Set **Start/End dates**.
5. Define **Schedule**:
   - Day(s) of week.
   - Start and end times.
6. Add an optional **Description** (students and teachers see this).
7. Click **Save**.

> **Tip:** Try to finalize schedule before the first day—teacher and student calendars rely on this.

---

### Duplicating a Class

Use duplication at the start of a new term.

1. From **All Classes**, find the class you want to copy.
2. Click **Duplicate**.
3. Confirm what you want to copy:
   - Structure
   - Schedule
   - Resources
4. Adjust:
   - New term dates.
   - Teacher assignment (if needed).
5. Save.

---

### Class Detail (Admin View)

Inside a class, you’ll see multiple tabs:

- **Overview**
  - Class description
  - Key dates
  - Weeks count
  - Class checklist

- **Roster**
  - Add/remove students
  - View attendance summaries
  - Email students

- **Lectures / Simulations / Assignments**
  - Manage all learning resources
  - Attach library items
  - Monitor submissions

- **Tests**
  - Assign tests
  - Manage AI-generated and template-based assessments

- **Gradebook**
  - View grades
  - Export CSV
  - Print grade reports

- **Attendance**
  - Take attendance (when covering for teachers)
  - Audit attendance patterns

---

### Uploading Class Syllabus

To ensure every class has a syllabus:

1. Open the class via **All Classes**.
2. Go to the **Overview** tab.
3. Find the **Syllabus** area.
4. Click **Upload Syllabus** (or drag-and-drop a PDF).
5. Once uploaded, the syllabus becomes visible to:
   - Teachers
   - Students
6. To update, upload a new PDF (this replaces the old one).

**Syllabus Best Practices:**

- Upload **before** the first day of class.
- Include:
  - Objectives
  - Schedule
  - Grading policy
  - Contact info
- Use PDF for consistent display.

---

### Managing Class Links

Use Links to centralize class-specific external resources.

**Adding a Link:**

1. Open class detail page.
2. Navigate to the **Links** section.
3. Click **Add Link**.
4. Fill in:
   - **Title** (e.g., “Course Resources Drive”).
   - **URL** (must start with `http://` or `https://`).
   - **Description** (optional).
5. Click **Save**.

**Common Link Examples:**

- Zoom/Teams/Meet room.
- Google Drive folder.
- External LMS or certification portal.
- Textbook publisher site.
- Class discussion forum or Slack workspace.

**Managing Links:**

- Click pencil icon to **Edit**.
- Click trash icon to **Delete**.
- Drag to **reorder** (if supported).

---

### Taking Attendance for Classes (as Admin)

Admins can step in when teachers are absent or for audits.

**Recording Attendance:**

1. Open the class from **All Classes**.
2. Go to the **Attendance** tab.
3. Choose the date at the top (defaults to today).
4. For each student:
   - Mark **Present**, **Absent**, or **Excused** (if available).
5. Click **Save Attendance**.

**Viewing Attendance History:**

- Scroll down to see previous dates and statuses.
- Filter by:
  - Date range.
  - Status.
  - Student.

**Attendance Reports:**

- Use **Export** to download CSV.
- Use **Print** for a hard copy.
- Use **Reports → Attendance Reports** for:
  - Per-class summaries.
  - Per-student summaries.
  - Clock hour calculations.

**Attendance Alerts:**

- Students below attendance thresholds (<80%) may be highlighted:
  - Icons on roster.
  - Flags in reports.
- Use this information to:
  - Notify advisors.
  - Plan interventions.
  - Inform financial aid decisions.

---

### Setting Grades for Students (Admin Role)

Admins can see and adjust gradebooks across all classes.

**Accessing a Class Gradebook:**

1. Open the class via **All Classes**.
2. Click the **Gradebook** tab.

Here you’ll see:

- Each student in a row.
- Each graded activity in a column.
- Class averages at the bottom.

**Entering or Adjusting Grades:**

1. Click any grade cell.
2. Type the numeric score.
3. Press **Enter** or click away.
4. Repeat for all required changes.
5. Click **Save Grades** at the bottom.

**Gradebook Options:**

- **Bulk import** via CSV (if supported).
- **Overrides** with reasons documented in notes.
- **Extra credit** by allowing scores above maximum points (if allowed by policy).
- **Incomplete** statuses (leave blank or use “I”, depending on configuration).

**Useful Features:**

- Click column headers to sort.
- View final grade percentages per row.
- See pass/fail highlighting.
- Export the entire gradebook to CSV.
- Use print view for meetings and accreditation.

**Grading Workflow Tips:**

- Teachers normally input grades; admins step in when:
  - Teachers need help.
  - Correcting mistakes.
  - Handling grade appeals.
- Manual grading is required for:
  - Essays and projects.
  - External assignments.
  - Participation.

**Gradebook Best Practices:**

- Save often during bulk updates.
- Document all manual adjustments.
- Check auto-graded items occasionally for correctness.
- Review grade distributions before finalizing.
- Export gradebooks at term end and store securely.

> Only **archive classes** after you’re sure grades and attendance are exported and final.

---

## 6. Teacher Onboarding & Support

Admins are responsible for getting teachers successfully into the system.

![Account page – Login](/docs/images/createteacher.png)

### Teacher Onboarding Checklist

1. **Create Teacher Account**
   - Use **Create Teacher** and populate basic info.
2. **Upload Signature (optional)**
   - In the teacher profile, upload a digital signature for certificates/transcripts.
3. **Encourage Teacher Profile Setup**
   - Ask teachers to log in and:
     - Set profile picture.
     - Confirm signature.
     - Add Teacher Links (office hours, class website, etc.).
4. **Verify Classes**
   - Ensure classes are assigned to the correct teacher in **All Classes**.
5. **Support with LMS Usage**
   - Point teachers to the **Teacher Playbook**.
   - Show them the **Dashboard**, **Class Workspaces**, and **Gradebook**.

### Re-Sending Teacher Login Info

1. Go to **Teacher List**.
2. Find the teacher.
3. Click **Resend**.
4. Confirm to send a new welcome/login email.

### Monitoring Teacher Dashboards

Admins can periodically:

- Review teacher class lists to ensure:
  - Correct assignments.
  - Syllabus uploaded.
  - Basic content (lectures/tests) set up.
- Support teachers by:
  - Helping upload shared resources.
  - Clarifying gradebook and attendance workflows.

---

## 7. Student Documents & Certificates

Document management and certificate tracking are key compliance tasks.

>![Account page – Login](/docs/images/agreesign.png)

### Uploading Documents

1. Open a **Student Profile**.
2. Go to the **Documents** tab.
3. Choose the category:
   - Required Docs (IDs, transcripts)
   - Certifications
   - To-Sign documents
4. Click **Upload Document**.
5. Select file (PDF/JPG/PNG).
6. Enter a description so staff know what it is.
7. Click **Save**.

---

### Managing To-Sign Documents & Staff Signatures

Some documents require electronic signatures from staff.

**Signing Workflow:**

1. From the admin dashboard, check for “Documents Awaiting Signature” alerts.
2. Click the alert to open the signature queue.
3. For each document:
   - Review the content.
   - Add your signature where prompted.
   - Mark as **Completed**.
4. Status updates:
   - Student profile shows signed vs pending.
   - Compliance dashboards update accordingly.

---

### Managing Certificates

Certificates are usually sent by teachers but admins can monitor and resend.

1. In the student profile, go to **Certificates**.
2. View the list of issued certificates:
   - Course name
   - Date issued
   - Sent by whom
3. To **resend a certificate**:
   - Click **Resend** (if available).
   - Confirm; the student receives another copy via email.
4. To **view** the actual PDF:
   - Click the stored URL or **View** button.

**Document Workflow Summary:**

1. Upload all required documents.
2. Assign signers for To-Sign documents.
3. Watch the signature queue and complete signatures.
4. Confirm that completion certificates are issued for finishing students.
5. Use **Download All** (if present) to export bundles for audits.

---

## 8. Financial Management & Tuition

The LMS includes built-in tracking for tuition and hours.

### How Automatic Tuition Works

- Each time a student enrolls in classes, the system:
  - Attempts to match class names to **Courses catalog** entries.
  - Uses multiple match levels:
    1. Exact match (program_name).
    2. Case-insensitive match.
    3. Short name match (shortName).
    4. Word-based fuzzy match (e.g., “RMF Framework” → “Risk Management Framework”).
- When matched, the system pulls:
  - `program_cost` (tuition)
  - `program_hours` (clock hours)
- These are added to the student’s **Tuition Breakdown** automatically.

### Registration Fee

- Every student automatically gets a **$75 registration fee** added.
- Shown as a separate line in Tuition Breakdown.

---

### Manual Tuition Entry (for exceptions)

Use manual entries when:

- Automatic match fails.
- Pricing is customized (scholarships, discounts, special programs).
- Courses are not yet in the catalog.

**To add a manual tuition item:**

1. Open student profile.
2. Scroll to **Tuition Breakdown**.
3. Click **ADD MANUAL COURSE**.
4. Fill:
   - **Course Name**
   - **Clock Hours**
   - **Tuition Cost**
5. Click **Add Course**.

Manual entries:

- Show with a **yellow "Manual Entry" badge**.
- Record who added it and when.

To delete a manual line:

1. Click the **Delete** button next to that entry.
2. Confirm.

**Best Practices:**

- Always add a **note** explaining why you used manual entry.
- Double-check totals before sending tuition agreements.
- Periodically update the course catalog to reduce manual entries.

![Manual tuition entry form](/docs/images/manual-tuition.png)

---

### Financial Dashboard

Access system-wide financials:

1. Go to **Financials** from Quick Actions.
2. Review:
   - Tuition totals per student.
   - Registration fee.
   - Amount paid / outstanding balances.
3. Use filters for:
   - Fully paid students.
   - Students with outstanding balances.
   - Program, cohort, etc.
4. Click a student row to update:
   - Payments received.
   - Payment notes.

**Bulk Update & Export:**

- Use bulk tools (if enabled) to update multiple payment statuses.
- Export financial views to CSV for:
  - Bookkeeping.
  - External accounting systems.
  - Administrative reviews.

---

### Financial Forecasting

Use **Revenue Forecast** to estimate future income.

1. Navigate to **Financials → Forecast**.
2. Review projected revenue based on:
   - Current enrollments.
   - Tuition totals.
3. For individual students:
   - Use the “Exclude from forecast” toggle in their profile when:
     - They are on full scholarship.
     - Their enrollment is uncertain.
4. Export forecast reports for budgeting.

---

## 9. Grades & Historical Records

Admins can see both in-system grades and imported historical records.

### Current LMS Grades

- In the student profile, open **Grades**.
- See:
  - Classes in progress.
  - Test scores and assignments.
  - Current course averages.
- Click a class name to see more granular grading detail.

**Print or Export Individual Grade Reports:**

- Use the report buttons (e.g., **Generate Grade Report**) to create a PDF.

---

### Historical Grades (from other institutions)

To add older or external grades:

1. Open the student profile.
2. Scroll to **Historical Grades**.
3. Click **Add Historical Grade**.
4. Enter:
   - Course Name
   - Grade (letter or percentage)
   - Credits
   - Completion Date
5. Click **Save**.

**Editing/Deleting Historical Grades:**

- Use **Edit** to correct fields.
- Use **Delete** to remove duplicate or incorrect entries.

---

### Transcript Generation

To generate a full transcript:

1. From student profile, click **Generate Transcript**.
2. System compiles:
   - All LMS course grades + hours.
   - All historical grades.
   - Total hours and GPA.
   - School branding.
3. Download as PDF or email to the student.

**Best Practices:**

- Only add historical grades from verified official transcripts.
- Use consistent naming for external courses.
- Note the source of external grades in student notes (if unusual).
- Use transcripts in advising and program completion checks.

---

## 10. Alumni Management

The LMS transitions students to alumni when programs are completed.

### Automatic Alumni Transition

- When a student completes required programs:
  - System checks requirements.
  - If met, status auto-changes to **Alumni**.
- Record moves from **Accepted Students** to **Alumni**.
- Data remains intact:
  - Grades, certificates, documents, notes.

---

### Manual Alumni Actions

**Move Student to Alumni Manually:**

1. Open student profile.
2. Click **Move to Alumni**.
3. Enter graduation/completion date.
4. Confirm.

**Adjust Alumni Dates:**

1. Open alumni profile.
2. Click **Update Alumni Date**.
3. Enter correct date.
4. Save.

**Re-enroll Alumni in New Programs:**

1. Open alumni profile.
2. Click **Re-enroll**.
3. Select new program.
4. Confirm.
5. Student returns to active status while keeping alumni history.

**Bulk Alumni Check:**

1. Go to **Students → Bulk Check Alumni**.
2. System finds students who likely qualify.
3. Review the list.
4. Confirm transitions.

---

### Alumni Tools

- **Alumni Report** – export all graduates with program and date.
- **Alumni Communications** – email graduates for:
  - Surveys
  - Job updates
  - Continuing education offers
- **Exclude Alumni from Forecasts** – use toggle to avoid skewing financial predictions.

**Best Practices:**

- Confirm all grades and attendance are final before moving to alumni.
- Ensure certificates are issued prior to transition.
- Add notes about next steps (jobs, further study).

---

## 11. Marketing, Events & Outreach

![Account page – Login](/docs/images/eventcal.png)

### Marketing

Use **Marketing** tools to manage outreach and campaigns:

- Create/update **email templates**.
- Manage **campaigns** with subject lines, body text, and segments.
- Track open/click behavior (if integrated).

### Events Dashboard

Manage events such as:

- Open houses
- Info sessions
- Workshops

**Creating an Event:**

1. Go to **Events Dashboard**.
2. Click **Create Event**.
3. Fill:
   - Title
   - Date & time
   - Location (physical or virtual)
   - Target audience
4. Assign staff.
5. Save.

### Interviews

1. Use **Interviews** to schedule applicant/student interviews.
2. Assign staff, date/time, location.
3. Set status:
   - Scheduled
   - Completed
   - No-Show
4. Log outcomes and notes.

### Interactions / Leads

Use **Interactions/Leads** to track outreach:

1. Record call, email, SMS attempts.
2. Mark interest level (hot, warm, cold).
3. Use built-in email composer to contact leads.
4. Export lists for further marketing or CRM integration.

### Mentors & Partners

- Store employer, mentor, and partner data.
- Link them to students or programs.
- Upload partnership agreements.
- Track outcomes (e.g., placements or referrals).

### Drip Campaigns

- Add leads to automated email sequences.
- Tailor messaging for:
  - Prospects
  - Current students
  - Alumni
  - Partners

---

## 12. Calendar & Scheduling

![Account page – Login](/docs/images/bigcal.png)

The admin calendar centralizes:

- Events
- Interviews
- Classes
- Tests
- Assignments
- Custom entries

### Basic Navigation

- Use **Prev/Today/Next** to move between time periods.
- Click a date cell to open the **Day modal**.
- In the Day modal, see all events on that date.

### Filtering

- Use checkboxes to show/hide:
  - Events
  - Interviews
  - Classes
  - Tests
  - Assignments
  - Custom
- Great for focusing on a specific workflow.

### Adding a Custom Event

1. Click **Add Custom Event**.
2. Fill:
   - Title
   - Description
   - Start/end date and time
   - Or mark **All-day** if appropriate.
3. Select which admins/teachers to notify.
4. Save.

### Exporting Calendar

- Use export buttons (if available) to:
  - Download `.ics`.
  - Add to Google Calendar.
  - Add to Outlook.

**Best Practices:**

- Use consistent naming (e.g., “Orientation – Spring 2025”).
- Always include time zone if dealing with virtual events.
- Review calendar daily for conflicts.
- Add recurring admin tasks (weekly staff meeting).

---

## 13. Reports & Analytics

![Account page – Login](/docs/images/reports.png)

### Predefined Reports

- Access via **Reports**.
- Common report types:
  - Enrollment summaries.
  - Attendance trends.
  - Financial snapshots.
- Use filters:
  - Cohort
  - Teacher
  - Date range
  - Program

### Report Charts (Custom Visualizations)

1. Go to **Report Charts**.
2. Select:
   - Data table (students, classes, leads).
   - Metrics (count, sum, average).
3. Add filters & group-by options.
4. Preview the chart.
5. Save it to add to **My Charts** on the dashboard.

### Audit Report

- Shows critical changes across the system:
  - Status changes
  - Account creations
  - Document uploads
- Filter by:
  - Actor
  - Date range
  - Action type
- Export logs for compliance or investigations.

### CSV Exports

- Many tables have **Export CSV**.
- Apply filters before exporting:
  - Exports respect current filters.
- Use CSV in spreadsheets or other systems.

---

## 14. Testing Library & Assessments

![Account page – Login](/docs/images/testlib.png)

### Test Library

- Central repository for standardized tests.
- Organize by:
  - Subject
  - Difficulty
  - Time limit

### Admin Test Library (Management)

**Adding a New Test:**

1. Open **Admin Test Library**.
2. Click **Add Test**.
3. Fill:
   - Title
   - Subject
   - Time limit
   - Metadata (difficulty, program, etc.)
4. Add questions:
   - Manually.
   - Or via CSV import template.

**CSV Upload:**

1. Download the CSV template.
2. Fill question data.
3. Upload CSV.
4. Confirm import mapping.

**Media Attachments:**

- Attach images/audio/video to questions as needed.

**Maintenance:**

- Periodically review teacher-created tests.
- Archive outdated ones.
- Use clear naming conventions (e.g., “2025_Q1 CNA Practice Exam”).

---

## 15. Messaging & Announcements

![Account page – Login](/docs/images/announcement.png)

### Announcements

Use Announcements for system-wide or audience-specific messages.

**Creating an Announcement:**

1. Go to **Messaging → Announcements**.
2. Click **New Announcement**.
3. Set:
   - Audience (teachers, students, both).
   - Title.
   - Message content.
   - Optional schedule date/time.
4. Save.

Announcements appear on dashboards for the chosen audience.

---

### Email Templates

- Create and manage reusable email templates.

**Editing a Template:**

1. Go to **Messaging → Email Templates**.
2. Select an existing template or create a new one.
3. Edit:
   - Subject line.
   - HTML body.
   - Text-only fallback.
4. Use placeholders like:
   - `{{name}}`
   - `{{username}}`
   - `{{class_name}}`
5. Save.

Templates are used by automated workflows (e.g., acceptance, welcome emails).

---

### Mailbox & Interactions

- If Mailbox is enabled:
  - View inbound and outbound email.
  - Filter by:
    - Inbox / Sent / Archived.
  - Assign conversations to specific staff.

- Use **Interactions** to log:
  - Phone calls.
  - SMS.
  - In-person meetings.

**Guidelines:**

- Use short, clear subject lines.
- Consistent tone that matches MDTS voice.
- Always update templates before major campaigns.

---

## 16. Settings & Configuration

![Account page – Login](/docs/images/branding.png)

### Branding

1. Go to **Settings → Branding**.
2. Upload:
   - Logos.
   - Favicon (if supported).
3. Choose:
   - Primary colors.
   - Secondary colors.
4. Preview changes.
5. Save when satisfied.

---

### Dropdowns

Manage lists that appear in dropdown menus across the LMS.

1. Open **Settings → Dropdowns**.
2. Choose the dropdown type:
   - Programs
   - Status options
   - Interview outcomes
   - Etc.
3. Add, edit, or remove options.

> Removing values can affect existing records—update with caution.

---

### Notifications

Configure automated alerts:

- Staff reminders (e.g., upcoming interviews).
- Student notifications (e.g., status change, new documents).

1. Open **Settings → Notifications**.
2. Toggle notifications on/off.
3. Adjust recipients and triggers.
4. Save.

---

### Todo Templates

Create reusable checklists for various workflows.

1. Go to **Todo Templates**.
2. Click **Create Template**.
3. Add items:
   - Description.
   - Due date (relative or fixed).
   - Assigned role (student, admin, advisor).
4. Save.

Assign these to students or leads as needed (see Advanced Features).

---

### Admins & Required Documents

- **Admins** – manage admin accounts (see Managing Users section).
- **Required Documents** – set default required documents for:
  - New students.
  - Specific programs.

### Signature Documents

- Configure templates for electronic signature.
- Associate them with:
  - Programs.
  - Enrollment workflows.
- Adjust who signs (student, admin, teacher).

> Always keep a record of changes for audit purposes.

---

## 17. Advanced Features & Tools

### Student Lookup & Search

Quickly find any student from any page.

1. Click **Student Lookup**.
2. Type:
   - Name
   - Email
   - Phone
   - Student ID
3. View matching results.
4. Click a result to jump directly to the profile.

---

### Student Merge Tool

Use when duplicate student records exist.

1. Go to **Other → Merge Students**.
2. Use search to locate suspected duplicates.
3. Select the **Primary record** (to keep).
4. Select the **Secondary record** (to merge).
5. Review the merge preview:
   - Enrollments.
   - Documents.
   - Notes.
6. If everything looks correct, click **Merge**.

The secondary record is archived; all data moves to the primary.

---

### To-Do List Management

**Creating To-Do Templates:**

1. Go to **Other → To-Do Templates**.
2. Click **Create Template**.
3. Name it (e.g., “New Student Onboarding”).
4. Add each task with:
   - Description.
   - Role (student/admin/advisor).
   - Due offset (e.g., “3 days after enrollment”).
5. Save.

**Assigning Templates to a Student:**

1. Open student profile.
2. Scroll to **To-Do List**.
3. Click **Assign Template**.
4. Select template and due date starting point.
5. Tasks appear in:
   - Student portal.
   - Admin student view.

**Tracking Completion:**

- Students mark tasks complete.
- Admins can:
  - View status.
  - Override by marking tasks complete/incomplete.

---

### Career Advisor Integration

See also Career Services above.

**Scheduling Career Interviews:**

1. In student or pre-reg profile, click **Schedule Interview**.
2. Enter:
   - Date/time.
   - Interview type (initial, mock, follow-up).
   - Assigned advisor.
   - Location/link.
3. Save to send notifications.

**Recording Outcomes:**

- After the interview, update:
  - Status (Completed/No-Show/Rescheduled).
  - Notes (key topics, commitments, next steps).

---

### Test Engine Access (Exam-only Users)

Allow non-enrolled users to access tests.

**Activating Test Engine Access:**

1. Go to **Students → Test Engine**.
2. Click **Activate by Email**.
3. Enter the user’s email.
4. Choose tests they can access.
5. Set access expiration date.
6. Save to send credentials.

**Deactivating:**

- Click **Deactivate** next to the user in the Test Engine list.

Use this for:
- Standalone exam candidates.
- Partner institution students.
- Pre-enrollment assessment testing.

---

### Mentors & Partners Management

**Adding Mentors:**

1. Go to **Other → Mentors**.
2. Click **Add Mentor**.
3. Enter:
   - Name
   - Organization
   - Contact info
4. Link to students or programs as needed.
5. Save.

**Partner Organizations:**

- Add employers, schools, and other entities.
- Track referrals and outcomes.
- Record agreements and terms.

---

### Interactions & Lead Tracking

**Recording an Interaction:**

1. Go to **Marketing → Interactions**.
2. Click **Add Interaction**.
3. Select type (phone, email, meeting, event).
4. Enter contact and segment (prospect/current/alumni).
5. Add notes and follow-up date.
6. Save.

**Lead Management:**

- Filter interactions to find hot leads.
- Add leads to drip campaigns.
- Convert to pre-registrations or students when ready.
- Export interaction history for CRM.

---

## 18. Data Exports & Compliance

> [Add screenshot: Export CSV button]

### Common Exports

- **Reports → Export CSV** – exports the current filtered view.
- **Attendance Reports** – export:
  - Per-class attendance.
  - Per-student attendance.
- **Gradebook Print/Export** – produce final grading records.
- **Leads/Interactions Export** – for marketing/CRM.

### Handling Exports Safely

- Store CSVs and PDFs on secured, access-controlled systems.
- Do not email sensitive files unless encrypted.
- Follow MDTS and institutional data retention policies.

### Compliance Checklist

- Maintain documents for required retention periods.
- Record decisions (accepted/denied) with notes.
- Use audit logs for all major changes.
- Coordinate with leadership on:
  - FERPA.
  - State and federal guidelines.
  - Accreditation requirements.

---

## 19. Troubleshooting & Support

### Common Problems & Fixes

**Cannot find a user**
- Check that you’re searching in the correct role (Student vs Teacher vs Alumni).
- Try global **Student Lookup** search.
- Confirm spelling or use partial name.

**Email not received**
- Ask recipient to check spam/junk folder.
- Confirm their email address in the profile.
- Verify the email template is active and correctly configured.
- Resend.

**Calendar event missing**
- Ensure the calendar filters for that event type are turned on.
- Check event audience and date.
- Confirm event was actually saved.

**Certificate failed to send**
- Confirm student email is correct.
- Try resending.
- Check logs or contact IT for email system issues.

**Tuition not calculating correctly**
- Confirm classes are correctly named and match catalog entries.
- Use Tuition Breakdown to verify which items are included.
- Add or adjust manual entries as needed.
- Document exceptions in notes.

**Document upload failure**
- Ensure file < 10MB.
- Confirm format is one of: PDF, JPG, PNG.
- Try a different browser or device.

**Student can’t log in**
- Confirm status is **Accepted**, not **Pending** or **Denied**.
- Use **Reset Password** to generate a new temporary password.
- Confirm they are using the correct login URL.

---

### When to Escalate

If you cannot resolve an issue:

1. Capture:
   - Exact error message.
   - Time and date.
   - Steps you took.
2. Contact MD Tech admin/leadership (see **Admins** page).
3. For infrastructure (server/email) issues, escalate to IT.
4. Document:
   - Cause.
   - Resolution steps.
   - Any lessons learned.
5. Update this manual or internal KB if needed to help future admins.

---

## 20. Change Log

- **December 2024** – Added This Week's Highlights and Next Week Highlights functionality to dashboard; expanded Managing Users section to include Alumni and Career Services; enhanced Class Management with syllabus upload, class links, detailed attendance tracking, and grade workflows; added Financial Management with manual tuition entry; added Grades & Historical Records, Alumni Management, and Advanced Features (student merge, to-do templates, career advisor integration, test engine, mentors/partners, interaction tracking).
- **January 2025** – Added inline help icons, teacher resend functionality, and manuals.
- **December 2024** – Expanded calendar filters and interactions tracking.
- **October 2024** – Introduced reporting charts and advanced document workflows.

---

Need help beyond this manual?  
Contact an MD Tech administrator using the **Admins** page or via your internal support channel.  
This manual is your first stop; admins and IT are your backup.
