# Links Management Feature Implementation

## Summary
Added comprehensive links management functionality to allow teachers and admins to add, edit, and remove links/resources from classes.

## Changes Made

### 1. Database Schema
- **File**: `scripts/add_links_column.js`
- Added `links` column to `mdtslms_classes` table (JSON type)
- Script automatically checks if column exists before adding

### 2. Class Model (`models/classModel.js`)
- Updated `mapClass()` function to include 'links' in JSON parsing array
- Added `addLink(classId, link)` function
  - Auto-increments link IDs
  - Stores link with title, url, and optional description
- Added `updateLink(classId, linkId, fields)` function
  - Updates title, url, and/or description
- Added `removeLink(classId, linkId)` function
  - Removes link by ID
- Exported all three new functions in module.exports

### 3. Admin Routes (`routes/admin.js`)
Added three POST routes:
- `/classes/:id/links` - Add new link
- `/classes/:id/links/:linkId/delete` - Remove link
- `/classes/:id/links/:linkId/update` - Update link
All routes redirect back to class page with `#links` anchor

### 4. Teacher Routes (`routes/teacher.js`)
Added identical routes for teacher access:
- `/classes/:id/links` - Add new link
- `/classes/:id/links/:linkId/delete` - Remove link
- `/classes/:id/links/:linkId/update` - Update link
All routes redirect to `/teacher/classes/:id#links`

### 5. Admin View Template (`views/view_class.ejs`)
- Added Links section after Tests section
- Features:
  - Empty state with icon when no links exist
  - List display of all links with title, URL, and description
  - External link icon for visual clarity
  - Edit and Delete buttons for each link
  - Collapsible "Add Link" form
  - Bootstrap modal for editing links
  - JavaScript `editLink()` function to populate modal
- Form fields:
  - Title (required)
  - URL (required, type="url" for validation)
  - Description (optional, textarea)

### 6. Teacher View Template (`views/teacher_view_class.ejs`)
- Added identical Links section as admin view
- Positioned before Discussion Board section
- Uses `/teacher/` routes instead of `/admin/`
- Same UI and functionality as admin view

## Data Structure

### Link Object
```javascript
{
  id: Number,           // Auto-incremented
  title: String,        // Required
  url: String,          // Required (validated as URL)
  description: String   // Optional
}
```

### Storage
- Links stored as JSON array in `mdtslms_classes.links` column
- Follows same pattern as lectures, simulations, assignments, tests

## User Interface

### Display
- Card-style section with "Links" title
- Each link shows:
  - Title (clickable, opens in new tab)
  - External link icon
  - Description (if provided)
  - Full URL below
  - Edit and Delete buttons

### Adding Links
- Collapsible form with "Add Link" button
- Required fields: Title, URL
- Optional field: Description
- Cancel button to hide form

### Editing Links
- Click Edit button on any link
- Bootstrap modal opens with current values pre-filled
- Save changes or cancel

### Deleting Links
- Click Delete button
- Browser confirmation dialog
- Immediate removal on confirmation

## Access Control
- Admins: Full access via `/admin/classes/:id`
- Teachers: Full access via `/teacher/classes/:id`
- Students: View-only (links visible but no add/edit/delete)

## Technical Notes
- Follows established pattern for class resources
- Uses Bootstrap 5.3.3 for UI components
- URLs validated by HTML5 input type="url"
- Modal requires Bootstrap JavaScript
- No AJAX - traditional form submissions with redirects
- Anchor links (#links) maintain scroll position after operations

## Testing Checklist
- [x] Database column added successfully
- [x] Model functions created and exported
- [x] Admin routes added
- [x] Teacher routes added
- [x] Admin view updated with Links section
- [x] Teacher view updated with Links section
- [x] No syntax errors in backend code
- [ ] Manual testing: Add link as admin
- [ ] Manual testing: Edit link as admin
- [ ] Manual testing: Delete link as admin
- [ ] Manual testing: Add link as teacher
- [ ] Manual testing: Edit link as teacher
- [ ] Manual testing: Delete link as teacher
- [ ] Manual testing: View links as student

## Files Modified
1. `/scripts/add_links_column.js` (created)
2. `/models/classModel.js`
3. `/routes/admin.js`
4. `/routes/teacher.js`
5. `/views/view_class.ejs`
6. `/views/teacher_view_class.ejs`

## Migration
Run once to add database column:
```bash
node scripts/add_links_column.js
```
