# Admin Staff Signature Feature

## Overview
Admins can now sign documents on behalf of staff members and see pending staff signatures on the admin dashboard.

## Features Implemented

### 1. Admin Can Sign Staff Documents
Admins have special permission to sign any document that requires a staff signature, even if the document was assigned to a specific staff member.

**Use Cases:**
- Staff member is unavailable
- Quick processing needed
- Staff member delegated signing to admin
- Emergency situations

### 2. Admin Dashboard Notification
The admin dashboard now displays an alert when there are documents awaiting staff signatures.

**Alert Features:**
- Shows count of pending staff signatures
- Yellow warning alert (dismissible)
- Link to view all pending documents
- Only appears when there are pending signatures

### 3. Modal with Pending Documents List
Clicking "View & Sign" opens a modal showing all documents requiring staff signatures.

**Modal Contents:**
- Document title
- Student name (if applicable)
- Document description
- Who to sign as (staff member name/email)
- Status badge (Pending/Viewed)
- Direct link to sign each document

### 4. Permission System
Updated the signing routes to allow:
- Original party user can sign (normal flow)
- Admin can sign if party_type is 'staff' (new feature)
- Security maintained: admins cannot sign student documents

## Technical Implementation

### Database Query
Added `getPendingStaffSignatures()` method to `signatureDocumentModel.js`:

```javascript
async getPendingStaffSignatures() {
  // Returns all documents where:
  // - party_type = 'staff'
  // - status IN ('pending', 'viewed')
  // - document status IN ('awaiting_signatures', 'partially_signed')
  // Includes student info and staff party details
}
```

### Route Updates

#### GET /document-signing/sign/:documentId/:partyId
**Before:**
```javascript
if (party.user_id !== req.session.user.id) {
  return res.status(403).send('Access denied');
}
```

**After:**
```javascript
const isAdmin = req.session.role === 'admin';
const isPartyUser = party.user_id === req.session.user.id;
const canSignAsStaff = isAdmin && party.party_type === 'staff';

if (!isPartyUser && !canSignAsStaff) {
  return res.status(403).send('Access denied');
}
```

#### POST /document-signing/sign/:documentId/:partyId
Similar permission check added to the POST route.

### Admin Dashboard Route
Added to `routes/admin.js`:
```javascript
let pendingStaffSignatures = [];
try {
  pendingStaffSignatures = await signatureDocumentModel.getPendingStaffSignatures();
} catch(err) {
  console.error('Error fetching pending staff signatures:', err);
}
```

Passed to view as `pendingStaffSignatures`.

### View Updates
Added to `views/admin_dashboard.ejs`:
1. Alert notification banner
2. Modal with document list
3. Bootstrap Icons for visual appeal

## User Flow

### Admin Perspective

1. **Login to Admin Dashboard**
   - Sees yellow alert if staff signatures pending
   - Alert shows count: "Staff Signatures Required: 3 documents awaiting staff signatures"

2. **Click "View & Sign"**
   - Modal opens showing all pending documents
   - Each document shows:
     - Title
     - Student name
     - Who to sign as (staff member)
     - Status badge

3. **Click on a Document**
   - Opens signing page
   - Admin sees PDF with signature fields
   - Can fill in and sign on behalf of staff

4. **Sign Document**
   - Signs as the assigned staff member
   - System records signature
   - Redirects to view page showing signed document
   - Document status updates

5. **Return to Dashboard**
   - Count decreases
   - Alert disappears when all documents signed

## Security Considerations

### What Admins CAN Do
✅ Sign documents where party_type = 'staff'
✅ View all documents in the system
✅ See who needs to sign
✅ Sign on behalf of any staff member

### What Admins CANNOT Do
❌ Sign documents where party_type = 'student'
❌ Sign without proper authentication
❌ Bypass audit trail (all actions logged)

### Audit Trail
All signatures are logged with:
- Who signed (admin's user ID)
- When they signed
- IP address
- User agent
- Document and party information

The system still records the signature under the staff party's record, but the audit log shows the admin performed the action.

## Files Modified

1. **models/signatureDocumentModel.js**
   - Added `getPendingStaffSignatures()` method
   - Queries for staff parties with pending/viewed status

2. **routes/documentSigning.js**
   - Updated GET `/sign/:documentId/:partyId` permission check
   - Updated POST `/sign/:documentId/:partyId` permission check
   - Added logic: `canSignAsStaff = isAdmin && party.party_type === 'staff'`

3. **routes/admin.js**
   - Added `signatureDocumentModel` import
   - Added query for pending staff signatures
   - Passed `pendingStaffSignatures` to dashboard view

4. **views/admin_dashboard.ejs**
   - Added alert notification banner
   - Added modal with document list
   - Included Bootstrap Icons

## Testing Checklist

- [ ] Admin sees alert when staff signatures are pending
- [ ] Alert shows correct count of pending documents
- [ ] Click "View & Sign" opens modal
- [ ] Modal lists all pending staff documents
- [ ] Each document shows correct information
- [ ] Clicking a document opens signing page
- [ ] Admin can successfully sign staff documents
- [ ] Signature is recorded in database
- [ ] Audit log shows admin's action
- [ ] Document status updates appropriately
- [ ] Alert disappears when all documents signed
- [ ] Admin cannot sign student documents
- [ ] Non-admin users cannot access this feature
- [ ] All links work correctly

## Benefits

1. **Efficiency**: Admins can process documents quickly
2. **Flexibility**: Staff absences don't block workflow
3. **Visibility**: Dashboard shows what needs attention
4. **Transparency**: Audit trail maintains accountability
5. **User-Friendly**: Simple modal interface
6. **Responsive**: Works on all devices

## Future Enhancements

Potential improvements:
- Email notification to admin when new staff signature needed
- Filter/search in modal for many documents
- Bulk signing capability
- Delegation system (staff explicitly delegates to admin)
- Report of admin signatures vs staff signatures
- Time limit for admin signing after staff has had opportunity
